/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaReader {
    private String nameSpaceURI = "http://www.w3.org/2001/XMLSchema";
    private final XPathFactory factory;
    private final Document doc;

    public SchemaReader(URL schemaUrl) throws Exception {
        DocumentBuilderFactory docBuilder = DocumentBuilderFactory.newInstance();
        docBuilder.setNamespaceAware(true);
        DocumentBuilder builder = docBuilder.newDocumentBuilder();
        this.doc = builder.parse(schemaUrl.openConnection().getInputStream());
        this.factory = XPathFactory.newInstance();
    }

    public List<String> getAllowedChoices(String mainElementName, String containingElementName) throws Exception {
        return this.processExpression("//xsd:schema/xsd:element[@name='" + mainElementName + "']/xsd:complexType/xsd:sequence/xsd:element[@name='" + containingElementName + "']/xsd:simpleType/xsd:restriction/xsd:enumeration", "value");
    }

    public List<String> getChildTags(String parentName) throws Exception {
        if (parentName == null) {
            return this.processExpression("*/xsd:element", "name");
        }
        return this.processExpression("*//xsd:element[@name='" + parentName + "']/xsd:complexType/xsd:sequence/xsd:element", "name");
    }

    public List<String> getParents(String name) throws Exception {
        XPath xpath = this.factory.newXPath();
        xpath.setNamespaceContext(this.getXSDContext());
        XPathExpression expr = xpath.compile("*//xsd:element");
        Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
        if (result == null) {
            return null;
        }
        NodeList nodes = (NodeList)result;
        if (nodes.getLength() < 1) {
            return null;
        }
        ArrayList<String> items = new ArrayList<String>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getAttributes().getNamedItem("name") != null && name.equals(node.getAttributes().getNamedItem("name").getNodeValue())) {
                try {
                    Node par = node.getParentNode().getParentNode().getParentNode();
                    if (par.getAttributes().getNamedItem("name") != null) {
                        items.add(par.getAttributes().getNamedItem("name").getNodeValue());
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return items;
    }

    private List<String> processExpression(String expression, String fieldName) throws Exception {
        XPath xpath = this.factory.newXPath();
        xpath.setNamespaceContext(this.getXSDContext());
        XPathExpression expr = xpath.compile(expression);
        Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
        if (result == null) {
            return null;
        }
        NodeList nodes = (NodeList)result;
        if (nodes.getLength() < 1) {
            return null;
        }
        ArrayList<String> items = new ArrayList<String>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            items.add(node.getAttributes().getNamedItem(fieldName).getNodeValue());
            ++i;
        }
        return items;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpaceURI) {
        this.nameSpaceURI = nameSpaceURI;
    }

    private NamespaceContext getXSDContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("xsd".equals(prefix)) {
                    return SchemaReader.this.nameSpaceURI;
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        };
    }
}

