/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.gda.util.list.ListUtils;

public class MapUtils {
    public static Map<String, String> createMap(String[] list1, String[] list2) {
        HashMap<String, String> ret = new HashMap<String, String>(list1.length);
        int i = 0;
        while (i < list1.length) {
            ret.put(list1[i].trim(), list2[i].trim());
            ++i;
        }
        return ret;
    }

    public static Map<String, String> createLinkedMap(String[] list1, String[] list2) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < list1.length) {
            ret.put(list1[i].trim(), list2[i].trim());
            ++i;
        }
        return ret;
    }

    public static <V> void putAllUniqueStrings(Map<String, V> data, Map<String, V> add) {
        for (String key : add.keySet()) {
            V value = add.get(key);
            if (data.containsKey(key)) {
                key = MapUtils.getUniqueKey(data.keySet(), key);
            }
            data.put(key, value);
        }
    }

    public static <V> void putUnique(Map<String, V> data, String key, V value) {
        if (data.containsKey(key)) {
            key = MapUtils.getUniqueKey(data.keySet(), key);
        }
        data.put(key, value);
    }

    private static String getUniqueKey(Set<String> keySet, String key) {
        int num = 1;
        while (keySet.contains(String.valueOf(key) + num)) {
            ++num;
        }
        return String.valueOf(key) + num;
    }

    public static String getString(Map<String, String> value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return null;
        }
        String line = value.toString();
        return line.substring(1, line.length() - 1);
    }

    public static Map<String, String> getMap(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value.trim())) {
            return null;
        }
        List<String> lines = ListUtils.getList(value);
        if (lines == null) {
            return null;
        }
        if (lines.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(lines.size());
        for (String line : lines) {
            String[] kv = line.split("=");
            if (kv == null || kv.length != 2) continue;
            ret.put(kv[0].trim(), kv[1].trim());
        }
        return ret;
    }

    public static void main(String[] args) {
        String test = "key=value, key1=value1, key2=value2";
        Map<String, String> v = MapUtils.getMap(test);
        System.out.println(v);
        test = " ";
        v = MapUtils.getMap(test);
        System.out.println(v);
        test = null;
        v = MapUtils.getMap(test);
        System.out.println(v);
        test = ",";
        v = MapUtils.getMap(test);
        System.out.println(v);
        test = "=";
        v = MapUtils.getMap(test);
        System.out.println(v);
        test = ",=,";
        v = MapUtils.getMap(test);
        System.out.println(v);
        test = ",,key=value";
        v = MapUtils.getMap(test);
        System.out.println(v);
    }
}

