/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.list;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.gda.util.list.SortNatural;

public class SortNaturalTest {
    @Test
    public void testBasicSort() {
        Object[] array = new String[]{"c", "b", "a"};
        Object[] expected = new String[]{"a", "b", "c"};
        Collections.sort(Arrays.asList(array), new SortNatural(false));
        Assert.assertArrayEquals((Object[])expected, (Object[])array);
    }

    @Test
    public void testNumericSort() {
        Object[] array = new String[20];
        Object[] expected = new String[20];
        int i = 0;
        while (i < 20) {
            expected[i] = array[i] = Integer.toString(i);
            ++i;
        }
        Collections.sort(Arrays.asList(array));
        Collections.sort(Arrays.asList(array), new SortNatural(false));
        Assert.assertArrayEquals((Object[])expected, (Object[])array);
    }

    @Test
    public void testStringsSort() {
        Object[] array = new String[]{"element", "edge", "preEdgeTime", "exafsStepType", "b", "initialEnergy", "a", "preEdgeStep", "edgeStep", "exafsToTime", "exafsFromTime", "gaf2", "gaf1", "finalEnergy", "exafsTime", "KStart", "edgeTime", "KWeighting"};
        Object[] expected = new String[]{"a", "b", "edge", "edgeStep", "edgeTime", "element", "exafsFromTime", "exafsStepType", "exafsTime", "exafsToTime", "finalEnergy", "gaf1", "gaf2", "initialEnergy", "KStart", "KWeighting", "preEdgeStep", "preEdgeTime"};
        Collections.sort(Arrays.asList(array), new SortNatural(false));
        Assert.assertArrayEquals((Object[])expected, (Object[])array);
    }

    @Test
    public void testStringsSortCaseSensitive() {
        Object[] array = new String[]{"element", "edge", "preEdgeTime", "exafsStepType", "b", "initialEnergy", "a", "preEdgeStep", "edgeStep", "exafsToTime", "exafsFromTime", "gaf2", "gaf1", "finalEnergy", "exafsTime", "KStart", "edgeTime", "KWeighting"};
        Object[] expected = new String[]{"KStart", "KWeighting", "a", "b", "edge", "edgeStep", "edgeTime", "element", "exafsFromTime", "exafsStepType", "exafsTime", "exafsToTime", "finalEnergy", "gaf1", "gaf2", "initialEnergy", "preEdgeStep", "preEdgeTime"};
        Collections.sort(Arrays.asList(array), new SortNatural(true));
        Assert.assertArrayEquals((Object[])expected, (Object[])array);
    }
}

