/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.list;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Comparator;

public class SortNatural<E>
implements Comparator<E> {
    private final boolean isCaseSensitive;

    public SortNatural(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = SortNatural.charAt(a, ia);
            char cb = SortNatural.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca < cb) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (ca > cb) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            ++ia;
            ++ib;
        }
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare(o1, o2, this.isCaseSensitive);
    }

    public int compare(Object o1, Object o2, boolean isCaseSensitive) {
        String b;
        String a;
        if (o1 == null) {
            o1 = "";
        }
        if (o2 == null) {
            o2 = "";
        }
        String o1String = this.getName(o1);
        String o2String = this.getName(o2);
        if (isCaseSensitive) {
            a = o1String;
            b = o2String;
        } else {
            String blc;
            a = o1String;
            b = o2String;
            String alc = o1String.toLowerCase();
            if (alc.equals(blc = o2String.toLowerCase()) && !a.equals(b)) {
                return this.compare(o1, o2, true);
            }
            a = alc;
            b = blc;
        }
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            int result;
            nzb = 0;
            nza = 0;
            char ca = SortNatural.charAt(a, ia);
            char cb = SortNatural.charAt(b, ib);
            while (ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = SortNatural.charAt(a, ++ia);
            }
            while (cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = SortNatural.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (result = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return result;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private String getName(Object o) {
        if (o instanceof File) {
            return ((File)o).getName();
        }
        try {
            Method getName = o.getClass().getMethod("getName", new Class[0]);
            if (getName.isAccessible()) {
                return (String)getName.invoke(o, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return o.toString();
    }

    static char charAt(String s, int i) {
        if (i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }
}

