/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.list;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uk.ac.gda.util.list.IntersectionException;

public class IntersectionUtils {
    public static void checkIntersection(List<Object[]> values) throws IntersectionException {
        if (values.size() < 2) {
            return;
        }
        Collections.sort(values, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return Double.compare(((Number)o1[0]).doubleValue(), ((Number)o2[0]).doubleValue());
            }
        });
        int i = 1;
        while (i < values.size()) {
            Object[] prev = values.get(i - 1);
            Object[] val = values.get(i);
            Number start1 = (Number)prev[0];
            Number end1 = (Number)prev[1];
            Number start2 = (Number)val[0];
            Number end2 = (Number)val[1];
            if (start1.doubleValue() > start2.doubleValue() || start1.doubleValue() > end2.doubleValue() || end1.doubleValue() > start2.doubleValue() || end1.doubleValue() > end2.doubleValue()) {
                IntersectionException e = new IntersectionException("The indices " + (i - 1) + " and " + i + " intersect!");
                e.setFirstName(prev[2].toString());
                e.setSecondName(val[2].toString());
                throw e;
            }
            ++i;
        }
    }
}

