/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class TokenFileParser {
    private String token = "\\t";
    private String commentChar = "#";
    private List<List<String>> data = new ArrayList<List<String>>(7);
    private BufferedReader reader;

    public TokenFileParser(URL url) throws IOException {
        this(url.openStream());
    }

    public TokenFileParser(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public TokenFileParser(InputStream unbuffered) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(unbuffered, "US-ASCII"));
    }

    public void parse() throws IOException {
        boolean firstLine = true;
        String l = null;
        while ((l = this.reader.readLine()) != null) {
            if (this.getCommentChar() != null && l.startsWith(this.getCommentChar())) continue;
            String[] line = l.trim().split(this.token);
            int index = 0;
            int i = 0;
            while (i < line.length) {
                String value = line[i].trim();
                if (!"".equals(value)) {
                    if (firstLine) {
                        this.data.add(new ArrayList(31));
                    }
                    List<String> d = this.data.get(index);
                    d.add(value);
                    ++index;
                }
                ++i;
            }
            firstLine = false;
        }
    }

    public List<String> getColumn(int icol) {
        return this.data.get(icol);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int size = this.data.get(0).size();
        int i = 0;
        while (i < size) {
            for (List<String> d : this.data) {
                buf.append("\t");
                buf.append(d.get(i));
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        File file = new File("/home/fcp94556/workspace/uk.ac.gda.core/src/gda/gui/exafs/Element-CoreHole.txt");
        TokenFileParser p = new TokenFileParser(file);
        System.out.println(p);
    }

    public Double[] getColumnAsDoubleArray(int i, int ... ignoreRows) {
        List<Double> ret = this.getColumnAsDoubleList(i, ignoreRows);
        return ret.toArray(new Double[ret.size()]);
    }

    public List<Double> getColumnAsDoubleList(int i, int ... ignoreRows) {
        ArrayList<Integer> ig = new ArrayList<Integer>(ignoreRows.length);
        int j = 0;
        while (j < ignoreRows.length) {
            ig.add(ignoreRows[j]);
            ++j;
        }
        List<String> values = this.data.get(i);
        ArrayList<Double> ret = new ArrayList<Double>(values.size());
        int row = 0;
        while (row < values.size()) {
            if (!ig.contains(row)) {
                ret.add(Double.parseDouble(values.get(row)));
            }
            ++row;
        }
        return ret;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(String commentChar) {
        this.commentChar = commentChar;
    }
}

