/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.gda.util.list.SortNatural;

public class SortingUtils {
    public static final Comparator<File> NATURAL_SORT = new SortNatural<File>(true);
    public static final Comparator<Object> NATURAL_SORT_CASE_INSENSITIVE = new SortNatural<Object>(false);
    private static final Comparator<File> DEFAULT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File one, File two) {
            return one.compareTo(two);
        }
    };

    public static List<File> getSortedFileList(File dir) {
        return SortingUtils.getSortedFileList(dir, DEFAULT_COMPARATOR);
    }

    public static List<File> getSortedFileList(File dir, boolean dirsFirst) {
        return SortingUtils.getSortedFileList(dir, DEFAULT_COMPARATOR, dirsFirst);
    }

    public static List<File> getSortedFileList(File dir, Comparator<File> comp) {
        return SortingUtils.getSortedFileList(dir, comp, false);
    }

    private static List<File> getSortedFileList(File dir, Comparator<File> comp, boolean dirsFirst) {
        List<File> ret;
        if (!dir.isDirectory()) {
            return null;
        }
        if (dir.listFiles() == null) {
            return null;
        }
        if (dirsFirst) {
            List<File> files;
            ret = new ArrayList<File>(dir.listFiles().length);
            List<File> dirs = SortingUtils.getSortedFileList(dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            }), comp);
            if (dirs != null) {
                ret.addAll(dirs);
            }
            if ((files = SortingUtils.getSortedFileList(dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            }), comp)) != null) {
                ret.addAll(files);
            }
        } else {
            ret = SortingUtils.getSortedFileList(dir.listFiles(), comp);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public static List<File> getSortedFileList(File dir, FileFilter fileFilter, Comparator<File> comp) {
        return SortingUtils.getSortedFileList(dir.listFiles(fileFilter), comp);
    }

    public static List<File> getSortedFileList(File dir, FileFilter fileFilter) {
        return SortingUtils.getSortedFileList(dir.listFiles(fileFilter), DEFAULT_COMPARATOR);
    }

    private static List<File> getSortedFileList(File[] fa, Comparator<File> comp) {
        if (fa == null || fa.length < 1) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(fa.length);
        files.addAll(Arrays.asList(fa));
        Collections.sort(files, comp);
        return files;
    }

    public static void removeIgnoredNames(Collection<String> sets, Collection<Pattern> patterns) {
        if (patterns == null) {
            return;
        }
        if (sets == null) {
            return;
        }
        Iterator<String> it = sets.iterator();
        block0: while (it.hasNext()) {
            String name = it.next();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(name).matches()) continue;
                it.remove();
                continue block0;
            }
        }
    }
}

