/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.Properties;
import uk.ac.gda.util.io.IOUtils;

public final class PropUtils {
    public static final Properties loadProperties(String path) throws IOException {
        File file = new File(path);
        return PropUtils.loadProperties(file);
    }

    public static final Properties loadProperties(File file) throws IOException {
        Properties fileProps = new Properties();
        if (!file.exists()) {
            return fileProps;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(stream);
            fileProps.load(in);
        }
        finally {
            IOUtils.close(stream, "Loading properties for file " + IOUtils.fileInfo(file));
        }
        return fileProps;
    }

    public static final Properties storeProperties(Properties props, String path) throws IOException {
        File file = new File(path);
        return PropUtils.storeProperties(props, file);
    }

    public static final Properties storeProperties(Properties props, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedOutputStream out = null;
        try {
            FileOutputStream os = new FileOutputStream(file);
            out = new BufferedOutputStream(os);
            props.store(out, "GDA/SDA Properties. Please do not edit this file.");
        }
        finally {
            IOUtils.close(out, "Storing properties for file " + IOUtils.fileInfo(file));
        }
        return props;
    }

    public static final Properties storeKeys(Properties props, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                out.println((String)it.next());
            }
        }
        finally {
            IOUtils.close(out, "Storing keys for file " + IOUtils.fileInfo(file));
        }
        return props;
    }

    public static final Properties loadProperties(HttpURLConnection connection) throws IOException {
        BufferedInputStream in = null;
        Properties urlProps = new Properties();
        try {
            InputStream stream = connection.getInputStream();
            in = new BufferedInputStream(stream);
            urlProps.load(in);
        }
        catch (Throwable throwable) {
            if (in != null) {
                IOUtils.close(in, "Loading properties from URL");
                connection.disconnect();
            }
            throw throwable;
        }
        if (in != null) {
            IOUtils.close(in, "Loading properties from URL");
            connection.disconnect();
        }
        return urlProps;
    }
}

