/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static void close(FileChannel channel, String msg) {
        if (channel == null) {
            logger.error("FileChannel is null", (Object)msg);
            return;
        }
        try {
            channel.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void close(ZipFile input, String msg) {
        if (input == null) {
            logger.error("ZipFile is null", (Object)msg, (Object)1);
            return;
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void close(Reader input, String msg) {
        if (input == null) {
            logger.error("Reader is null", (Object)msg, (Object)1);
            return;
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void close(Writer output, String msg) {
        if (output == null) {
            logger.error("Writer is null", (Object)msg, (Object)1);
            return;
        }
        try {
            output.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void close(OutputStream output, String msg) {
        if (output == null) {
            logger.error("OutputStream is null", (Object)msg, (Object)1);
            return;
        }
        try {
            output.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void close(InputStream input, String msg) {
        if (input == null) {
            logger.error("InputStream is null", (Object)msg, (Object)1);
            return;
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            logger.error("Cannot close stream", (Throwable)ioe);
        }
    }

    public static String fileInfo(File f) {
        if (f == null) {
            return "File is null";
        }
        return f.getPath();
    }

    public static String fileInfo(ZipFile f) {
        if (f == null) {
            return "File is null";
        }
        return f.getName();
    }
}

