/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class FileUtils {
    private static final String NEWFOLDER = "New Folder";
    public static final char BOM;
    private static final int TESTNUM = 1;
    private static DateFormat dateFormat;

    static {
        byte[] b1 = new byte[]{-17, -69, -65};
        String bomstr = " ";
        try {
            bomstr = new String(b1, 0, 3, "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not initialize byte order marker");
        }
        BOM = bomstr.charAt(0);
    }

    public static final boolean recursiveDelete(File parent) {
        if (parent.exists()) {
            if (parent.isDirectory()) {
                File[] files = parent.listFiles();
                int ifile = 0;
                while (ifile < files.length) {
                    if (files[ifile].isDirectory()) {
                        FileUtils.recursiveDelete(files[ifile]);
                    }
                    if (files[ifile].exists()) {
                        files[ifile].delete();
                    }
                    ++ifile;
                }
            }
            return parent.delete();
        }
        return false;
    }

    public static final void deleteContents(File parent) {
        if (parent.isDirectory()) {
            File[] files = parent.listFiles();
            int ifile = 0;
            while (ifile < files.length) {
                if (files[ifile].isDirectory()) {
                    FileUtils.recursiveDelete(files[ifile]);
                }
                files[ifile].delete();
                ++ifile;
            }
        }
    }

    public static File getUnique(File dir, String template, String ext) {
        String extension = ext != null ? (ext.startsWith(".") ? ext : "." + ext) : null;
        File file = new File(dir, String.valueOf(template) + extension);
        if (!file.exists()) {
            return file;
        }
        return FileUtils.getUnique(dir, template, ext, 1);
    }

    public static File getUnique(File dir, String template, String ext, int i) {
        File file;
        String extension = ext != null ? (ext.startsWith(".") ? ext : "." + ext) : null;
        File file2 = file = ext != null ? new File(dir, String.valueOf(template) + i + extension) : new File(dir, String.valueOf(template) + i);
        if (!file.exists()) {
            return file;
        }
        return FileUtils.getUnique(dir, template, ext, ++i);
    }

    public static final void recursiveDeleteOnExit(File parent) {
        parent.deleteOnExit();
        if (parent.isDirectory()) {
            File[] files = parent.listFiles();
            int ifile = 0;
            while (ifile < files.length) {
                if (files[ifile].isDirectory()) {
                    FileUtils.recursiveDeleteOnExit(files[ifile]);
                }
                files[ifile].deleteOnExit();
                ++ifile;
            }
        }
    }

    private static final int getBufferSize() {
        String size = System.getProperty("org.diamond.util.io.fileutils.buffer.size");
        if (size == null) {
            return 4096;
        }
        return Integer.parseInt(size);
    }

    public static final void recursiveCopy(File source_dir, File destination_dir) throws IOException {
        FileUtils.recursiveCopy(source_dir, destination_dir, new byte[FileUtils.getBufferSize()]);
    }

    private static final void recursiveCopy(File source_dir, File destination_dir, byte[] buffer) throws IOException {
        if (source_dir == null || destination_dir == null) {
            return;
        }
        if (!source_dir.exists()) {
            throw new FileNotFoundException(source_dir.getAbsolutePath());
        }
        if (!source_dir.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (source_dir.equals(destination_dir)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (destination_dir.exists()) {
            FileUtils.recursiveDelete(destination_dir);
        }
        destination_dir.mkdirs();
        File[] files = source_dir.listFiles();
        int ifile = 0;
        while (ifile < files.length) {
            File from = files[ifile];
            File to = new File(destination_dir, from.getName());
            if (from.isDirectory()) {
                FileUtils.recursiveCopy(from, to, buffer);
            } else {
                FileUtils.copy(from, to, buffer);
            }
            ++ifile;
        }
    }

    public static final void recursiveCopyNio(File source_dir, File destination_dir) throws IOException {
        if (source_dir == null || destination_dir == null) {
            return;
        }
        if (!source_dir.exists()) {
            throw new FileNotFoundException(source_dir.getAbsolutePath());
        }
        if (!source_dir.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (source_dir.equals(destination_dir)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (destination_dir.exists()) {
            FileUtils.recursiveDelete(destination_dir);
        }
        destination_dir.mkdirs();
        File[] files = source_dir.listFiles();
        int ifile = 0;
        while (ifile < files.length) {
            File from = files[ifile];
            File to = new File(destination_dir, from.getName());
            if (from.isDirectory()) {
                FileUtils.recursiveCopyNio(from, to);
            } else {
                FileUtils.copyNio(from, to);
            }
            ++ifile;
        }
    }

    public static final void recursiveCopyNioNoDelete(File source_dir, File destination_dir) throws IOException {
        if (source_dir == null || destination_dir == null) {
            return;
        }
        if (!source_dir.exists()) {
            throw new FileNotFoundException(source_dir.getAbsolutePath());
        }
        if (!source_dir.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (source_dir.equals(destination_dir)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        File[] files = source_dir.listFiles();
        int ifile = 0;
        while (ifile < files.length) {
            File from = files[ifile];
            File to = new File(destination_dir, from.getName());
            if (from.isDirectory()) {
                FileUtils.recursiveCopyNioNoDelete(from, to);
            } else {
                FileUtils.copyNioNoCopyOver(from, to);
            }
            ++ifile;
        }
    }

    public static final void recursiveIncrementalCopy(File source_dir, File destination_dir) throws IOException {
        FileUtils.recursiveIncrementalCopy(source_dir, destination_dir, new int[3]);
    }

    public static final void recursiveIncrementalCopy(File source_dir, File destination_dir, int[] inf) throws IOException {
        FileUtils.recursiveIncrementalCopy(source_dir, destination_dir, inf, new byte[FileUtils.getBufferSize()]);
    }

    private static final void recursiveIncrementalCopy(File source_dir, File destination_dir, int[] inf, byte[] buffer) throws IOException {
        if (inf[2] == -1) {
            return;
        }
        if (source_dir == null || destination_dir == null || inf.length < 3) {
            return;
        }
        if (!source_dir.exists()) {
            throw new FileNotFoundException(source_dir.getAbsolutePath());
        }
        if (!source_dir.isDirectory()) {
            throw new IOException("recursiveCopy should only be used for folders!");
        }
        if (source_dir.equals(destination_dir)) {
            throw new IOException("Cannot copy folder on to itself!");
        }
        if (destination_dir.exists()) {
            destination_dir.mkdirs();
        }
        File[] files = source_dir.listFiles();
        int ifile = 0;
        while (ifile < files.length) {
            File from = files[ifile];
            File to = new File(destination_dir, from.getName());
            if (from.isDirectory()) {
                FileUtils.recursiveIncrementalCopy(from, to, inf, buffer);
            } else if (from.lastModified() > to.lastModified()) {
                FileUtils.copy(from, to, buffer);
                inf[0] = inf[0] + 1;
            } else {
                inf[1] = inf[1] + 1;
            }
            ++ifile;
        }
    }

    public static final void copy(File source_file, String destination_dir) throws IOException {
        File dest_file = null;
        if (source_file.isDirectory()) {
            dest_file = new File(destination_dir);
            FileUtils.recursiveCopy(source_file, dest_file);
        } else {
            String fname = source_file.getName();
            dest_file = new File(destination_dir, fname);
            FileUtils.copy(source_file, dest_file);
        }
    }

    public static final void copy(File source_file, File destination_file) throws IOException {
        FileUtils.copy(source_file, destination_file, new byte[FileUtils.getBufferSize()]);
    }

    public static final void copy(File source_file, File destination_file, byte[] buffer) throws IOException {
        if (!source_file.exists()) {
            return;
        }
        File parTo = destination_file.getParentFile();
        if (!parTo.exists()) {
            parTo.mkdirs();
        }
        if (!destination_file.exists()) {
            destination_file.createNewFile();
        }
        InputStream source = null;
        OutputStream destination = null;
        try {
            int bytes_read;
            source = new BufferedInputStream(new FileInputStream(source_file));
            destination = new BufferedOutputStream(new FileOutputStream(destination_file));
            while ((bytes_read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytes_read);
            }
        }
        finally {
            source.close();
            destination.close();
        }
    }

    public static final void copyNio(File source_file, File destination_file) throws IOException {
        if (!source_file.exists()) {
            return;
        }
        File parTo = destination_file.getParentFile();
        if (!parTo.exists()) {
            parTo.mkdirs();
        }
        if (!destination_file.exists()) {
            destination_file.createNewFile();
        }
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            srcChannel = new FileInputStream(source_file).getChannel();
            dstChannel = new FileOutputStream(destination_file).getChannel();
            ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        finally {
            if (srcChannel != null) {
                srcChannel.close();
            }
            if (dstChannel != null) {
                dstChannel.close();
            }
        }
    }

    public static final void copyNioNoCopyOver(File source_file, File destination_file) throws IOException {
        if (destination_file.exists()) {
            return;
        }
        FileUtils.copyNio(source_file, destination_file);
    }

    public static final void write(BufferedInputStream source, File destination_file) throws IOException {
        File parTo = destination_file.getParentFile();
        if (!parTo.exists()) {
            parTo.mkdirs();
        }
        if (!destination_file.exists()) {
            destination_file.createNewFile();
        }
        BufferedOutputStream destination = null;
        try {
            int bytes_read;
            destination = new BufferedOutputStream(new FileOutputStream(destination_file));
            byte[] buffer = new byte[FileUtils.getBufferSize()];
            while ((bytes_read = source.read(buffer)) != -1) {
                ((OutputStream)destination).write(buffer, 0, bytes_read);
            }
        }
        finally {
            source.close();
            if (destination != null) {
                ((OutputStream)destination).close();
            }
        }
    }

    public static final void write(InputStream source_raw, OutputStream destination_raw) throws IOException {
        FilterOutputStream destination = null;
        BufferedInputStream source = null;
        try {
            int bytes_read;
            source = new BufferedInputStream(source_raw);
            destination = new BufferedOutputStream(destination_raw);
            byte[] buffer = new byte[FileUtils.getBufferSize()];
            while ((bytes_read = source.read(buffer)) != -1) {
                ((BufferedOutputStream)destination).write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static final byte[] getByteArrayFromStream(InputStream source) throws IOException {
        return FileUtils.getByteArrayFromStream(source, true);
    }

    public static final byte[] getByteArrayFromStream(InputStream source, boolean shouldClose) throws IOException {
        ByteArrayOutputStream destination = FileUtils.getByteStream(source, shouldClose);
        return destination.toByteArray();
    }

    public static final ByteArrayOutputStream getByteStream(InputStream source) throws IOException {
        return FileUtils.getByteStream(source, true);
    }

    public static final ByteArrayOutputStream getByteStream(InputStream source, boolean shouldClose) throws IOException {
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        try {
            int bytes_read;
            byte[] buffer = new byte[FileUtils.getBufferSize()];
            while ((bytes_read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (source != null && shouldClose) {
                source.close();
            }
        }
        return destination;
    }

    public static final StringBuffer readFile(File file) throws Exception {
        return FileUtils.readFile(new FileInputStream(file));
    }

    public static final StringBuffer readFile(InputStream in) throws Exception {
        return FileUtils.readFile(in, null);
    }

    public static final StringBuffer readFile(InputStream in, String charsetName) throws Exception {
        BufferedReader ir = null;
        try {
            int c;
            ir = charsetName != null ? new BufferedReader(new InputStreamReader(in, charsetName)) : new BufferedReader(new InputStreamReader(in));
            StringBuffer currentStrBuffer = new StringBuffer();
            char[] buf = new char[4096];
            while ((c = ir.read(buf, 0, 4096)) > 0) {
                currentStrBuffer.append(buf, 0, c);
            }
            StringBuffer stringBuffer = currentStrBuffer;
            return stringBuffer;
        }
        finally {
            if (ir != null) {
                ir.close();
            }
        }
    }

    public static final List<String> readFileAsList(File f) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String str;
            FileReader reader = new FileReader(f);
            br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                l.add(str);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return l;
    }

    public static final List<String> readFileAsList(File file, String encodingOfFile, boolean removeBom, boolean trimLines) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, encodingOfFile));
        ArrayList<String> fileContents = new ArrayList<String>(33);
        try {
            String line;
            boolean readFirstLine = false;
            while ((line = br.readLine()) != null) {
                if (removeBom && !readFirstLine) {
                    readFirstLine = true;
                    char firstChar = line.charAt(0);
                    if (firstChar == BOM) {
                        line = line.substring(1);
                    }
                }
                if (trimLines) {
                    fileContents.add(line.trim());
                    continue;
                }
                fileContents.add(line);
            }
        }
        finally {
            ((Reader)br).close();
            ((InputStream)is).close();
        }
        return fileContents;
    }

    public static boolean isUnix(String stringToTest) {
        boolean isUnix = false;
        StringBuffer sb = new StringBuffer(stringToTest);
        int unix = 0;
        int win = 0;
        int j = 0;
        while (j < sb.length()) {
            if (unix >= 1) {
                isUnix = true;
                break;
            }
            if (win >= 1) {
                isUnix = false;
                break;
            }
            if (sb.charAt(j) == '\n' && (j == 0 || sb.charAt(j - 1) != '\r')) {
                ++unix;
            } else if (sb.charAt(j) == '\n' && (j == 0 || sb.charAt(j - 1) == '\r')) {
                ++win;
            }
            ++j;
        }
        return isUnix;
    }

    public static boolean isBOM(String stringToTest) {
        if (stringToTest == null) {
            return false;
        }
        if ("".equals(stringToTest)) {
            return false;
        }
        return stringToTest.charAt(0) == BOM;
    }

    public static void write(File file, String text, String encoding) throws Exception {
        BufferedWriter b = null;
        try {
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
            b = new BufferedWriter(writer);
            b.write(text.toCharArray());
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    public static void write(File file, String text) throws Exception {
        FileUtils.write(file, text, "US-ASCII");
    }

    public static void write(OutputStream out, String text, String charset, boolean addBomIfNeeded) throws Exception {
        BufferedWriter b = null;
        try {
            if (addBomIfNeeded && text.charAt(0) != BOM) {
                text = String.valueOf(BOM) + text;
            }
            b = new BufferedWriter(new OutputStreamWriter(out, charset));
            b.write(text.toCharArray());
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    public static void write(File file, List<String> list) throws Exception {
        BufferedWriter bw = null;
        try {
            FileOutputStream out = new FileOutputStream(file);
            bw = new BufferedWriter(new OutputStreamWriter(out));
            int i = 0;
            while (i < list.size()) {
                String line = list.get(i);
                bw.write(line, 0, line.length());
                bw.newLine();
                ++i;
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    public static File createNewUniqueDir(File file) {
        return FileUtils.createNewUniqueDir(file, NEWFOLDER);
    }

    public static File createNewUniqueDir(File file, String templateName) {
        File sug = new File(file, templateName);
        if (sug.exists()) {
            int i = 2;
            while (sug.exists()) {
                sug = new File(file, String.valueOf(templateName) + " (" + i + ")");
                ++i;
            }
        }
        sug.mkdirs();
        return sug;
    }

    public static final String getParentDirName(String name) {
        int indx = name.lastIndexOf("/");
        String ret = indx > -1 ? name.substring(0, indx) : "/";
        if (!ret.endsWith("/")) {
            ret = String.valueOf(ret) + "/";
        }
        return ret;
    }

    public static final void writeToFile(File file, InputStream fromNoClose) throws Exception {
        BufferedInputStream buf = new BufferedInputStream(fromNoClose);
        FileOutputStream fl = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fl);
        try {
            int bytes_read;
            byte[] buffer = new byte[FileUtils.getBufferSize()];
            while ((bytes_read = buf.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public static long getDiskSpace(File dir) {
        long inuse = 0L;
        if (dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                inuse += FileUtils.getDiskSpace(element);
                ++n2;
            }
        } else {
            inuse += dir.length();
        }
        return inuse;
    }

    public static boolean isDiskSpaceAvaliableMB(File tmp, long sizeInMB) throws IOException {
        return FileUtils.isDiskSpaceAvaliable(tmp, sizeInMB * 1000000L);
    }

    public static boolean isDiskSpaceAvaliable(File tmp, long sizeInB) throws IOException {
        if (!tmp.getParentFile().exists()) {
            tmp.getParentFile().mkdirs();
        }
        if (!tmp.exists()) {
            tmp.createNewFile();
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(tmp, "rw");
            raf.setLength(sizeInB);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
            tmp.delete();
        }
    }

    public static long getFileSizeRecursive(File file, boolean subFolders) {
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    long tmpSize;
                    File element = fileArray[n2];
                    if ((subFolders || !element.isDirectory()) && (tmpSize = FileUtils.getFileSizeRecursive(element, subFolders)) != -1L) {
                        size += tmpSize;
                    }
                    ++n2;
                }
                return size;
            }
            return -1L;
        }
        return file.length();
    }

    public static String getFileExtension(String fileName) {
        int posExt = fileName.lastIndexOf(".");
        return posExt == -1 ? "" : fileName.substring(posExt + 1);
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileNameNoExtension(File file) {
        String fileName = file.getName();
        int posExt = fileName.lastIndexOf(".");
        return posExt == -1 ? fileName : fileName.substring(0, posExt);
    }

    public static String formatSize(long longSize, int decimalPos) {
        double size;
        double val;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        if ((val = (size = (double)longSize) / 1.073741824E9) > 1.0) {
            return fmt.format(val).concat(" GB");
        }
        val = size / 1048576.0;
        if (val > 1.0) {
            return fmt.format(val).concat(" MB");
        }
        val = size / 1024.0;
        if (val > 10.0) {
            return fmt.format(val).concat(" KB");
        }
        return fmt.format(size).concat(" bytes");
    }

    public static String getSystemInfo(File file) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Last Modified ");
        buf.append(dateFormat.format(new Date(file.lastModified())));
        buf.append("\nFile size ");
        buf.append(FileUtils.formatSize(file.length(), 0));
        return buf.toString();
    }
}

