/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.beans.xml;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLObjectConfigFileValidator {
    private static final Logger logger = LoggerFactory.getLogger(XMLObjectConfigFileValidator.class);
    private static final String SAX_REPORT_VALIDATION_ERRORS = "http://xml.org/sax/features/validation";
    private static final String XERCES_REPORT_SCHEMA_ERRORS = "http://apache.org/xml/features/validation/schema";
    private static final String XERCES_FULL_SCHEMA_GRAMMAR_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String XERCES_SCHEMA_WITHOUT_NAMESPACE = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String JAXP_DOCBUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String JAXP_DOCBUILDER_FACTORY_XERCES_IMPL = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String JAXP_PROPS_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_PROPS_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3_SCHEMA_LANGUAGE_URI = "http://www.w3.org/2001/XMLSchema";
    private String SchemaUrl = null;
    private String xmlInstanceDocumentURL = null;
    private InputSource xmlInstanceDocumentSource = null;

    private boolean xerces2Validate() throws Exception {
        SAXParser parser = new SAXParser();
        parser.setFeature(SAX_REPORT_VALIDATION_ERRORS, true);
        parser.setFeature(XERCES_REPORT_SCHEMA_ERRORS, true);
        parser.setFeature(XERCES_FULL_SCHEMA_GRAMMAR_CHECKING, true);
        parser.setProperty(XERCES_SCHEMA_WITHOUT_NAMESPACE, (Object)this.SchemaUrl);
        Validator handler = new Validator();
        parser.setErrorHandler((ErrorHandler)handler);
        if (this.xmlInstanceDocumentSource != null) {
            parser.parse(this.xmlInstanceDocumentSource);
        } else {
            parser.parse(this.xmlInstanceDocumentURL);
        }
        handler.throwIfRequired();
        return true;
    }

    private boolean jaxpValidate() throws Exception {
        System.setProperty(JAXP_DOCBUILDER_FACTORY, JAXP_DOCBUILDER_FACTORY_XERCES_IMPL);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setAttribute(JAXP_PROPS_SCHEMA_LANGUAGE, W3_SCHEMA_LANGUAGE_URI);
        factory.setAttribute(JAXP_PROPS_SCHEMA_SOURCE, this.SchemaUrl);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Validator handler = new Validator();
        builder.setErrorHandler(handler);
        if (this.xmlInstanceDocumentSource != null) {
            builder.parse(this.xmlInstanceDocumentSource);
        } else {
            builder.parse(this.xmlInstanceDocumentURL);
        }
        handler.throwIfRequired();
        return false;
    }

    public boolean validateFile(String SchemaUrl, String xmlInstanceDocumentURL, boolean useXercesValidation) throws Exception {
        this.SchemaUrl = this.getPath(SchemaUrl);
        this.xmlInstanceDocumentURL = this.getPath(xmlInstanceDocumentURL);
        this.xmlInstanceDocumentSource = null;
        if (useXercesValidation) {
            return this.xerces2Validate();
        }
        return this.jaxpValidate();
    }

    private String getPath(String fileOrUrl) {
        if (fileOrUrl == null) {
            return null;
        }
        if (fileOrUrl.indexOf(":") > -1) {
            return fileOrUrl;
        }
        if (fileOrUrl.startsWith("/")) {
            return fileOrUrl;
        }
        return new File(fileOrUrl).getAbsolutePath();
    }

    private CharArrayWriter getCharArrayWriterFromInputSource(InputSource source) throws UnsupportedEncodingException {
        Reader cs = source.getCharacterStream();
        BufferedReader in = null;
        if (cs == null) {
            InputStream i = source.getByteStream();
            in = new BufferedReader(new InputStreamReader(i, "UTF-8"));
        } else {
            in = new BufferedReader(cs);
        }
        try {
            CharArrayWriter out = new CharArrayWriter();
            try {
                int charRead;
                while ((charRead = ((Reader)in).read()) > -1) {
                    out.write(charRead);
                }
            }
            catch (IOException e) {
                logger.error("Cannot read file", (Throwable)e);
                out = null;
            }
            CharArrayWriter charArrayWriter = out;
            return charArrayWriter;
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException e) {
                logger.error("Cannot close stream", (Throwable)e);
            }
        }
    }

    public InputSource validateSource(String SchemaUrl, InputSource xmlInstanceDocumentSource, boolean useXercesValidation) throws Exception {
        CharArrayWriter data = this.getCharArrayWriterFromInputSource(xmlInstanceDocumentSource);
        return this.validateSource(SchemaUrl, data.toCharArray(), useXercesValidation);
    }

    public InputSource validateSource(String SchemaUrl, char[] xmlCharacters, boolean useXercesValidation) throws Exception {
        InputSource source = new InputSource(new CharArrayReader(xmlCharacters));
        this.SchemaUrl = SchemaUrl;
        this.xmlInstanceDocumentURL = null;
        this.xmlInstanceDocumentSource = source;
        boolean valid = false;
        valid = useXercesValidation ? this.xerces2Validate() : this.jaxpValidate();
        if (valid) {
            return new InputSource(new CharArrayReader(xmlCharacters));
        }
        return null;
    }

    private class Validator
    extends DefaultHandler {
        private SAXParseException saxParseException = null;

        private Validator() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.saxParseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.saxParseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.saxParseException = exception;
        }

        public void throwIfRequired() throws Exception {
            if (this.saxParseException != null) {
                throw this.saxParseException;
            }
        }
    }
}

