/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.beans.xml;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.gda.util.beans.xml.URLResolver;
import uk.ac.gda.util.beans.xml.XMLHelpersException;
import uk.ac.gda.util.beans.xml.XMLHelpersXMLValidationError;
import uk.ac.gda.util.beans.xml.XMLObjectConfigFileValidator;

public class XMLHelpers {
    private static final Logger logger = LoggerFactory.getLogger(XMLHelpers.class);
    private static URLResolver urlResolver;
    private static Map<UrlClassLoaderPair, XMLContext> xmlContextCache;

    static {
        xmlContextCache = new HashMap<UrlClassLoaderPair, XMLContext>();
    }

    private static XMLContext createXMLContext(URL mappingURL, ClassLoader cl) throws MappingException, IOException {
        XMLContext context;
        if (mappingURL == null || cl == null) {
            throw new NullPointerException();
        }
        UrlClassLoaderPair urlClassLoaderPair = new UrlClassLoaderPair(mappingURL, cl);
        if (xmlContextCache.containsKey(urlClassLoaderPair)) {
            context = xmlContextCache.get(urlClassLoaderPair);
        } else {
            Mapping mapping = new Mapping(cl);
            mapping.loadMapping(mappingURL);
            context = new XMLContext();
            context.addMapping(mapping);
            context.setProperty("org.exolab.castor.indent", (Object)"true");
            xmlContextCache.put(urlClassLoaderPair, context);
        }
        return context;
    }

    public static Object createFromXML(URL mappingURL, Class<? extends Object> cl, URL schemaUrl, String filename) throws Exception {
        return XMLHelpers.createFromXML(mappingURL, cl, schemaUrl, filename, true);
    }

    public static Object createFromXML(URL mappingURL, Class<? extends Object> cl, URL schemaUrl, InputSource source) throws Exception {
        return XMLHelpers.createFromXMLInternal(mappingURL, cl, schemaUrl, source, true);
    }

    public static Object createFromXML(URL mappingURL, Class<? extends Object> cl, URL schemaUrl, InputSource source, boolean validate) throws Exception {
        return XMLHelpers.createFromXMLInternal(mappingURL, cl, schemaUrl, source, validate);
    }

    public static Object createFromXML(URL mappingURL, Class<? extends Object> cl, URL schemaUrl, File file) throws Exception {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            Object object = XMLHelpers.createFromXMLInternal(mappingURL, cl, schemaUrl, new InputSource(reader), true);
            return object;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Object createFromXML(URL mappingURL, Class<? extends Object> cl, URL schemaUrl, String filename, boolean validate) throws Exception {
        URI uri = new URI(filename);
        InputSource source = uri.getScheme() != null && (uri.getScheme().equals("http") || uri.getScheme().equals("file")) ? new InputSource(uri.toURL().openStream()) : new InputSource(new FileReader(filename));
        return XMLHelpers.createFromXMLInternal(mappingURL, cl, schemaUrl, source, validate);
    }

    public static void setFromXML(Object existingBean, URL mappingUrl, URL schemaUrl, String xml) throws Exception {
        XMLObjectConfigFileValidator validator;
        if (urlResolver != null) {
            mappingUrl = urlResolver.resolve(mappingUrl);
            schemaUrl = urlResolver.resolve(schemaUrl);
        }
        InputSource source = null;
        if (schemaUrl != null && (source = (validator = new XMLObjectConfigFileValidator()).validateSource(schemaUrl.toString(), xml.toCharArray(), true)) == null) {
            throw new XMLHelpersXMLValidationError();
        }
        try {
            Method clear = existingBean.getClass().getMethod("clear", new Class[0]);
            clear.invoke(existingBean, new Object[0]);
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            throw new XMLHelpersException("Internal Error: All beans used with XMLHelpers must define a clear() method to release resources - " + existingBean.getClass().getName());
        }
        Unmarshaller unmarshaller = XMLHelpers.createXMLContext(mappingUrl, existingBean.getClass().getClassLoader()).createUnmarshaller();
        unmarshaller.setClass(existingBean.getClass());
        unmarshaller.setObject(existingBean);
        unmarshaller.unmarshal(source);
    }

    private static Object createFromXMLInternal(URL mappingUrl, Class<? extends Object> cl, URL schemaUrl, InputSource source, boolean validate) throws Exception {
        XMLObjectConfigFileValidator validator;
        if (urlResolver != null) {
            mappingUrl = urlResolver.resolve(mappingUrl);
            schemaUrl = urlResolver.resolve(schemaUrl);
        }
        if (validate && schemaUrl != null && (source = (validator = new XMLObjectConfigFileValidator()).validateSource(schemaUrl.toString(), source, true)) == null) {
            throw new XMLHelpersXMLValidationError();
        }
        Object obj = null;
        if (mappingUrl != null) {
            Unmarshaller unmarshaller = XMLHelpers.createXMLContext(mappingUrl, cl.getClassLoader()).createUnmarshaller();
            unmarshaller.setClass(cl);
            obj = unmarshaller.unmarshal(source);
        } else {
            obj = Unmarshaller.unmarshal(cl, (InputSource)source);
        }
        if (!obj.getClass().equals(cl)) {
            throw new XMLHelpersException("Class created is incorrect = " + obj.getClass().getName());
        }
        return obj;
    }

    public static void writeToXML(URL mappingURL, Object object, File file) throws Exception {
        FileWriter writer = new FileWriter(file);
        XMLHelpers.writeToXMLInternal(mappingURL, object, writer);
    }

    public static void writeToXML(URL mappingURL, Object object, String filename) throws Exception {
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        FileWriter writer = new FileWriter(filename);
        XMLHelpers.writeToXMLInternal(mappingURL, object, writer);
    }

    public static void writeToXML(URL mappingURL, Object object, Writer fileData) throws Exception {
        XMLHelpers.writeToXMLInternal(mappingURL, object, fileData);
    }

    private static void writeToXMLInternal(URL mappingURL, Object object, Writer writer) throws Exception {
        try {
            if (urlResolver != null) {
                mappingURL = urlResolver.resolve(mappingURL);
            }
            if (mappingURL != null) {
                XMLContext context = XMLHelpers.createXMLContext(mappingURL, object.getClass().getClassLoader());
                Marshaller marshaller = context.createMarshaller();
                marshaller.setWriter(writer);
                marshaller.marshal(object);
            } else {
                Marshaller.marshal((Object)object, (Writer)writer);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static Object readBean(File beanFile, Class<?> beanClass) throws Exception {
        URL mapping = null;
        URL schema = null;
        Field[] fa = beanClass.getFields();
        int i = 0;
        while (i < fa.length) {
            if (fa[i].getName().equalsIgnoreCase("mappingurl")) {
                mapping = (URL)fa[i].get(null);
            } else if (fa[i].getName().equalsIgnoreCase("schemaurl")) {
                schema = (URL)fa[i].get(null);
            }
            ++i;
        }
        return XMLHelpers.createFromXML(mapping, beanClass, schema, beanFile);
    }

    public static URLResolver getUrlResolver() {
        return urlResolver;
    }

    public static void setUrlResolver(URLResolver urlResolver) {
        XMLHelpers.urlResolver = urlResolver;
    }

    private static class UrlClassLoaderPair {
        private URL mappingURL;
        private ClassLoader cl;

        public UrlClassLoaderPair(URL mappingURL, ClassLoader cl) {
            this.mappingURL = mappingURL;
            this.cl = cl;
        }

        private boolean equalsHelper(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UrlClassLoaderPair)) {
                return false;
            }
            UrlClassLoaderPair other = (UrlClassLoaderPair)obj;
            if (!this.equalsHelper(this.mappingURL, other.mappingURL)) {
                return false;
            }
            return this.equalsHelper(this.cl, other.cl);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.mappingURL == null ? 0 : this.mappingURL.hashCode());
            result = 31 * result + (this.cl == null ? 0 : this.cl.hashCode());
            return result;
        }
    }
}

