/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import uk.ac.gda.util.FilePathConverter;

public class UnixToWindowsFilePathConverter
implements FilePathConverter,
InitializingBean {
    private String windowsSubString;
    private String unixSubString;

    @Override
    public String converttoInternal(String filepath) {
        String replace = StringUtils.replace((String)filepath, (String)this.unixSubString, (String)this.windowsSubString);
        return StringUtils.replace((String)replace, (String)"/", (String)"\\");
    }

    @Override
    public String converttoExternal(String filepath) {
        String replace = StringUtils.replace((String)filepath, (String)this.windowsSubString, (String)this.unixSubString);
        return StringUtils.replace((String)replace, (String)"\\", (String)"/");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.windowsSubString == null || this.unixSubString == null) {
            throw new IllegalArgumentException("windowsSubString == null || unixSubString==null");
        }
    }

    public String getWindowsSubString() {
        return this.windowsSubString;
    }

    public void setWindowsSubString(String windowsSubString) {
        this.windowsSubString = windowsSubString;
    }

    public String getUnixSubString() {
        return this.unixSubString;
    }

    public void setUnixSubString(String unixSubString) {
        this.unixSubString = unixSubString;
    }
}

