/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util;

import java.util.Collection;
import java.util.HashSet;

public class ThreadManager {
    protected static Collection<String> takenNames = new HashSet<String>(89);

    public static Thread getThread() {
        Thread thread = new Thread();
        ThreadManager.createUniqueNameFromStack(thread);
        return thread;
    }

    public static Thread getThread(Runnable target) {
        Thread thread = new Thread(target);
        ThreadManager.createUniqueNameFromStack(thread);
        return thread;
    }

    public static void createUniqueNameFromStack(Thread thread) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String call = null;
        int i = 1;
        while (i < stack.length) {
            String name = stack[i].getClassName();
            if (!name.equals(ThreadManager.class.getName())) {
                call = name;
                break;
            }
            ++i;
        }
        if (call != null) {
            thread.setName(ThreadManager.getUniqueName(call));
        }
    }

    protected static String getUniqueName(String call) {
        int count = 1;
        String name = "GDA Thread " + call + "_" + count;
        while (takenNames.contains(name)) {
            name = "GDA Thread " + call + "_" + ++count;
        }
        takenNames.add(name);
        if (takenNames.size() > 100) {
            takenNames.clear();
        }
        return name;
    }

    public static Thread getThread(Runnable target, String name) {
        return new Thread(target, name);
    }

    public static Thread getThread(String name) {
        return new Thread(name);
    }

    public static void main(String[] args) {
        ThreadNameStackTester t = new ThreadNameStackTester();
        t.create();
    }

    private static class ThreadNameStackTester {
        private ThreadNameStackTester() {
        }

        void create() {
            Thread blank = ThreadManager.getThread();
            Thread run = ThreadManager.getThread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Hello");
                }
            });
            Thread named1 = ThreadManager.getThread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("you");
                }
            }, "Name1");
            Thread named2 = ThreadManager.getThread("Name2");
            System.out.println(blank.getName());
            System.out.println(run.getName());
            System.out.println(named1.getName());
            System.out.println(named2.getName());
        }
    }
}

