/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util;

public class CorrectionUtils {
    public static double correct(double ffr, double processDeadTime) {
        double in = 0.0;
        double maxOut = 1.0 / processDeadTime * Math.exp(-1.0);
        if (ffr < 0.0) {
            in = 0.0;
        } else if (ffr > maxOut) {
            in = 1.0 / processDeadTime;
        } else {
            int i = 0;
            while (i < 50) {
                long div = 1 << i;
                double tryIn = in + 1.0 / ((double)div * processDeadTime);
                if (ffr >= tryIn * Math.exp(-tryIn * processDeadTime)) {
                    in = tryIn;
                }
                ++i;
            }
        }
        return in;
    }

    public static double getK(double ppdt, double ffr, double sfr) {
        double actualCountRate = CorrectionUtils.correct(ffr, ppdt);
        return actualCountRate / sfr;
    }
}

