/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util;

import java.io.UnsupportedEncodingException;

public class ByteUtils {
    protected ByteUtils() {
    }

    public static short byteArrayToShort(byte[] paRawBytes, boolean pbBigEndian) {
        return ByteUtils.byteArrayToShort(paRawBytes, 0, pbBigEndian);
    }

    public static short byteArrayToShort(byte[] paRawBytes, int piOffset, boolean pbBigEndian) {
        byte iHigh;
        byte iLow;
        int iRetVal = -1;
        if (paRawBytes.length < piOffset + 2) {
            return -1;
        }
        if (pbBigEndian) {
            iLow = paRawBytes[piOffset + 1];
            iHigh = paRawBytes[piOffset + 0];
        } else {
            iLow = paRawBytes[piOffset + 0];
            iHigh = paRawBytes[piOffset + 1];
        }
        iRetVal = iHigh << 8 | 0xFF & iLow;
        return (short)iRetVal;
    }

    public static int byteArrayToInt(byte[] paRawBytes, boolean pbBigEndian) {
        return ByteUtils.byteArrayToInt(paRawBytes, 0, pbBigEndian);
    }

    public static int byteArrayToInt(byte[] paRawBytes, int piOffset, boolean pbBigEndian) {
        byte iHigh;
        byte iMid;
        byte iLow;
        byte iLowest;
        int iRetVal = -1;
        if (paRawBytes.length < piOffset + 4) {
            return iRetVal;
        }
        if (pbBigEndian) {
            iLowest = paRawBytes[piOffset + 3];
            iLow = paRawBytes[piOffset + 2];
            iMid = paRawBytes[piOffset + 1];
            iHigh = paRawBytes[piOffset + 0];
        } else {
            iLowest = paRawBytes[piOffset + 0];
            iLow = paRawBytes[piOffset + 1];
            iMid = paRawBytes[piOffset + 2];
            iHigh = paRawBytes[piOffset + 3];
        }
        iRetVal = iHigh << 24 | iMid << 16 | iLow << 8 | 0xFF & iLowest;
        return iRetVal;
    }

    public static byte[] intToByteArray(int piValueToConvert, boolean pbBigEndian) {
        byte[] aRetVal = new byte[4];
        byte iLowest = (byte)(piValueToConvert & 0xFF);
        byte iLow = (byte)(piValueToConvert >> 8 & 0xFF);
        byte iMid = (byte)(piValueToConvert >> 16 & 0xFF);
        byte iHigh = (byte)(piValueToConvert >> 24 & 0xFF);
        if (pbBigEndian) {
            aRetVal[3] = iLowest;
            aRetVal[2] = iLow;
            aRetVal[1] = iMid;
            aRetVal[0] = iHigh;
        } else {
            aRetVal[0] = iLowest;
            aRetVal[1] = iLow;
            aRetVal[2] = iMid;
            aRetVal[3] = iHigh;
        }
        return aRetVal;
    }

    public static String byteArrayToString(byte[] paRawBytes) {
        return ByteUtils.byteArrayToString(paRawBytes, 0, paRawBytes.length);
    }

    public static String byteArrayToString(byte[] paRawBytes, int piOffset, int piLength) {
        if (paRawBytes.length < piOffset + piLength) {
            return "";
        }
        String oBeautifulString = new String(paRawBytes, piOffset, piLength);
        int i = 0;
        if (oBeautifulString.matches("^\\W")) {
            oBeautifulString = "";
        } else {
            i = piOffset;
            while (i < piOffset + piLength) {
                if (paRawBytes[i] < 32 || paRawBytes[i] > 128) break;
                ++i;
            }
            oBeautifulString = oBeautifulString.substring(0, i - piOffset);
        }
        return oBeautifulString;
    }

    public static byte[] stringToByteArray(String pstrStringToConvert) {
        return ByteUtils.stringToByteArray(pstrStringToConvert, "US-ASCII");
    }

    public static byte[] stringToByteArray(String pstrStringToConvert, String pstrCharSet) {
        byte[] aRecordData = null;
        try {
            aRecordData = (String.valueOf(pstrStringToConvert) + '\u0000').getBytes(pstrCharSet);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("WARNING: " + e);
            aRecordData = (String.valueOf(pstrStringToConvert) + '\u0000').getBytes();
        }
        return aRecordData;
    }

    public static String getMARFSourceCodeRevision() {
        return "$Revision: 1.6 $";
    }
}

