/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.jython.commands;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericExtendedCommand {
    public static boolean matches(String line, List<String> commands) {
        for (String command : commands) {
            if (!Pattern.compile(String.valueOf(command) + " (.*)").matcher(line.trim()).matches()) continue;
            return true;
        }
        return false;
    }

    public static String getCorrectionMessage(String line, List<String> commands) {
        String message = null;
        for (String command : commands) {
            Matcher matcher = Pattern.compile("(" + command + ") (.*)").matcher(line.trim());
            if (!matcher.matches()) continue;
            try {
                String commaSeparatedArgs = GenericExtendedCommand.splitSpaces(matcher.group(2).trim());
                message = String.format("The command '%s' should be used with brackets and comma separated arguments in Jython e.g. '%s(%s)'", matcher.group(1).trim(), matcher.group(1).trim(), commaSeparatedArgs);
            }
            catch (Exception exception) {
                message = "Cammands in scripts should use brackets.";
            }
        }
        return message;
    }

    private static String splitSpaces(String a) {
        String[] args = a.split(" ");
        StringBuilder buf = new StringBuilder();
        if (args.length > 1) {
            int i = 0;
            while (i < args.length - 1) {
                buf.append(args[i].trim());
                buf.append(",");
                buf.append(" ");
                ++i;
            }
        }
        buf.append(args[args.length - 1]);
        return buf.toString();
    }

    public static String getResolution(String line, List<String> commands) {
        String message = null;
        for (String command : commands) {
            Matcher matcher = Pattern.compile("(" + command + ") (.*)").matcher(line.trim());
            if (!matcher.matches()) continue;
            try {
                String commaSeparatedArgs = GenericExtendedCommand.splitSpaces(matcher.group(2).trim());
                message = String.format("%s(%s)", matcher.group(1).trim(), commaSeparatedArgs);
            }
            catch (Exception exception) {
                message = null;
            }
        }
        return message;
    }
}

