/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.jython;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.gda.jython.AbstractExtendedCommand;
import uk.ac.gda.jython.ExtendedCommand;
import uk.ac.gda.jython.commands.AliasCommand;
import uk.ac.gda.jython.commands.GenericExtendedCommand;
import uk.ac.gda.jython.commands.PosCommand;
import uk.ac.gda.jython.commands.ScanCommand;

public class ExtendedJythonSyntax {
    public static final List<ExtendedCommand> COMMANDS;

    static {
        ArrayList<AbstractExtendedCommand> tmp1 = new ArrayList<AbstractExtendedCommand>(3);
        tmp1.add(new PosCommand());
        tmp1.add(new AliasCommand());
        tmp1.add(new ScanCommand());
        COMMANDS = Collections.unmodifiableList(tmp1);
    }

    public static boolean isCommand(String line, List<String> commands) {
        for (ExtendedCommand cmd : COMMANDS) {
            if (!cmd.matches(line)) continue;
            return true;
        }
        return GenericExtendedCommand.matches(line, commands);
    }

    public static String getCorrectionMessage(String line, List<String> commands) {
        String message = null;
        for (ExtendedCommand cmd : COMMANDS) {
            if (!cmd.matches(line)) continue;
            message = cmd.getCorrectionMessage();
        }
        if (GenericExtendedCommand.matches(line, commands)) {
            message = GenericExtendedCommand.getCorrectionMessage(line, commands);
        }
        if (message == null) {
            return null;
        }
        return String.valueOf(message) + " Please right click and choose quick fix (in Problems view).";
    }

    public static String getResolution(String line, List<String> commands) {
        for (ExtendedCommand cmd : COMMANDS) {
            if (!cmd.matches(line)) continue;
            return cmd.getResolution();
        }
        if (GenericExtendedCommand.matches(line, commands)) {
            return GenericExtendedCommand.getResolution(line, commands);
        }
        return null;
    }
}

