/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.doe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.gda.doe.FieldValue;

public class RangeInfo
implements Serializable {
    private List<FieldValue> experiments = new ArrayList<FieldValue>(7);

    public void clear() {
        this.experiments.clear();
    }

    public List<FieldValue> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(List<FieldValue> e) {
        if (e == null) {
            this.experiments.clear();
            return;
        }
        this.experiments = e;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.experiments == null ? 0 : this.experiments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeInfo other = (RangeInfo)obj;
        return !(this.experiments == null ? other.experiments != null : !this.experiments.equals(other.experiments));
    }

    public void set(FieldValue fieldValue) {
        int index = this.experiments.indexOf(fieldValue);
        if (index > -1) {
            this.experiments.set(index, fieldValue);
            return;
        }
        this.experiments.add(fieldValue);
    }

    public static String format(List<RangeInfo> info) {
        StringBuilder buf = new StringBuilder();
        buf.append(info.get(0).getHeader());
        buf.append("\n");
        for (RangeInfo rangeInfo : info) {
            buf.append(rangeInfo.getValues());
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        for (FieldValue field : this.getExperiments()) {
            buf.append(field.getName());
            buf.append("\t");
        }
        return buf.toString();
    }

    public String getValues() {
        StringBuilder buf = new StringBuilder();
        for (FieldValue field : this.getExperiments()) {
            buf.append(field.getValue());
            buf.append("\t");
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.experiments.isEmpty();
    }

    public Map<String, Class<?>> getColumnClasses() {
        LinkedHashMap columns = new LinkedHashMap(31);
        for (FieldValue fv : this.experiments) {
            columns.put(fv.getName(), fv.getOriginalObject().getClass());
        }
        return columns;
    }

    public String getColumnValue(String name) {
        if (this.experiments.isEmpty()) {
            return null;
        }
        if (name == null) {
            return null;
        }
        for (FieldValue fv : this.experiments) {
            if (!name.equals(fv.getName())) continue;
            return fv.getValue();
        }
        return null;
    }
}

