/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.doe;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.doe.DOEControl;
import uk.ac.gda.doe.DOEField;
import uk.ac.gda.doe.FieldContainer;
import uk.ac.gda.doe.FieldValue;
import uk.ac.gda.doe.RangeInfo;

public class DOEUtils {
    private static final int MAX_RANGE_SIZE = 1000;

    public static List<RangeInfo> getInfoFromList(List<Object> obs) throws Exception {
        ArrayList<RangeInfo> exp = new ArrayList<RangeInfo>(31);
        DOEUtils.getInfoFromList(obs, 0, exp);
        return exp;
    }

    private static void getInfoFromList(List<Object> obs, int index, List<RangeInfo> exp) throws Exception {
        if (index >= obs.size()) {
            return;
        }
        Object bean = obs.get(index);
        if (bean != null) {
            List<RangeInfo> runs = DOEUtils.getInfo(bean);
            for (RangeInfo rangeInfo : runs) {
                if (!rangeInfo.isEmpty()) {
                    exp.add(rangeInfo);
                }
                DOEUtils.getInfoFromList(obs, index + 1, exp);
            }
        } else {
            DOEUtils.getInfoFromList(obs, index + 1, exp);
        }
    }

    public static List<RangeInfo> getInfo(Object bean) throws Exception {
        ArrayList<Collection<FieldContainer>> weightedFields = new ArrayList<Collection<FieldContainer>>(11);
        int i = 0;
        while (i < 11) {
            weightedFields.add(new LinkedHashSet(7));
            ++i;
        }
        DOEUtils.readAnnotations(null, bean, weightedFields, -1);
        List<FieldContainer> expandedFields = DOEUtils.expandFields(weightedFields);
        ArrayList<RangeInfo> ret = new ArrayList<RangeInfo>(31);
        DOEUtils.getInfo(new RangeInfo(), expandedFields, 0, ret);
        return ret;
    }

    protected static void getInfo(RangeInfo info, List<FieldContainer> orderedFields, int index, List<RangeInfo> ret) throws Exception {
        if (index >= orderedFields.size()) {
            RangeInfo clone = BeansFactory.deepClone(info);
            ret.add(clone);
            return;
        }
        FieldContainer field = orderedFields.get(index);
        Object originalObject = field.getOriginalObject();
        String stringValue = (String)BeansFactory.getBeanValue(originalObject, field.getName());
        if (stringValue == null) {
            DOEUtils.getInfo(info, orderedFields, index + 1, ret);
            return;
        }
        String range = stringValue.toString();
        List<? extends Number> vals = DOEUtils.expand(range, field.getAnnotation().type());
        for (Number number : vals) {
            if (vals.size() > 1) {
                info.set(new FieldValue(field.getOriginalObject(), field.getName(), number.toString()));
            }
            DOEUtils.getInfo(info, orderedFields, index + 1, ret);
        }
    }

    public static List<? extends Object> expand(Object bean) throws Exception {
        ArrayList<Collection<FieldContainer>> weightedFields = new ArrayList<Collection<FieldContainer>>(11);
        int i = 0;
        while (i < 11) {
            weightedFields.add(new LinkedHashSet(7));
            ++i;
        }
        DOEUtils.readAnnotations(null, bean, weightedFields, -1);
        List<FieldContainer> expandedFields = DOEUtils.expandFields(weightedFields);
        ArrayList<Object> ret = new ArrayList<Object>(31);
        Object clone = BeansFactory.deepClone(bean);
        DOEUtils.expand(clone, expandedFields, 0, ret);
        return ret;
    }

    private static List<FieldContainer> expandFields(List<Collection<FieldContainer>> weightedFields) {
        ArrayList<FieldContainer> ret = new ArrayList<FieldContainer>(31);
        for (Collection<FieldContainer> fields : weightedFields) {
            for (FieldContainer fc : fields) {
                if (ret.contains(fc)) continue;
                ret.add(0, fc);
            }
        }
        return ret;
    }

    protected static void readAnnotations(FieldContainer parent, Object fieldObject, List<Collection<FieldContainer>> weightedFields, int index) throws Exception {
        if (fieldObject.getClass().getName().startsWith("java.lang.")) {
            return;
        }
        Field[] ff = null;
        if (fieldObject instanceof List) {
            List vals = (List)fieldObject;
            if (!vals.isEmpty()) {
                ff = vals.get(0).getClass().getDeclaredFields();
            }
        } else {
            ff = fieldObject.getClass().getDeclaredFields();
        }
        if (ff == null) {
            return;
        }
        List<Field> controlledFields = DOEUtils.getControlledFields(fieldObject, ff);
        int i = 0;
        while (i < ff.length) {
            Field f = ff[i];
            if (controlledFields == null || !controlledFields.contains(f)) {
                DOEField doe = f.getAnnotation(DOEField.class);
                FieldContainer fc = new FieldContainer();
                fc.setField(f);
                fc.setOriginalObject(fieldObject);
                fc.setParent(parent);
                fc.setListIndex(index);
                fc.setAnnotation(doe);
                if (doe != null) {
                    Collection<FieldContainer> list = weightedFields.get(doe.value());
                    if (fieldObject instanceof List) {
                        List values = (List)fieldObject;
                        int j = 0;
                        while (j < values.size()) {
                            list.add(fc.clone(values.get(j), j));
                            ++j;
                        }
                    } else {
                        list.add(fc);
                    }
                } else {
                    try {
                        if (fieldObject instanceof List) {
                            List values = (List)fieldObject;
                            int j = 0;
                            while (j < values.size()) {
                                DOEUtils.readAnnotations(fc, values.get(j), weightedFields, j);
                                ++j;
                            }
                        } else {
                            Object value = BeansFactory.getBeanValue(fieldObject, f.getName());
                            if (value != null) {
                                DOEUtils.readAnnotations(fc, value, weightedFields, -1);
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++i;
        }
    }

    private static List<Field> getControlledFields(Object fieldObject, Field[] ff) throws Exception {
        if (fieldObject instanceof List) {
            return null;
        }
        ArrayList<Field> controlled = new ArrayList<Field>(7);
        int i = 0;
        while (i < ff.length) {
            String[] vals;
            Object value;
            Field f = ff[i];
            DOEControl control = f.getAnnotation(DOEControl.class);
            if (control != null && (value = BeansFactory.getBeanValue(fieldObject, f.getName())) != null && Arrays.asList(vals = control.values()).contains(value)) {
                String[] ffs = control.fields();
                int j = 0;
                while (j < vals.length) {
                    if (!vals[j].equals(value)) {
                        controlled.add(fieldObject.getClass().getDeclaredField(ffs[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return controlled;
    }

    protected static void expand(Object clone, List<FieldContainer> orderedFields, int index, List<Object> ret) throws Exception {
        if (index >= orderedFields.size()) {
            if (!ret.contains(clone)) {
                ret.add(clone);
            }
            return;
        }
        FieldContainer field = orderedFields.get(index);
        Object originalObject = field.getOriginalObject();
        String stringValue = (String)BeansFactory.getBeanValue(originalObject, field.getName());
        if (stringValue == null) {
            DOEUtils.expand(clone, orderedFields, index + 1, ret);
            return;
        }
        String range = stringValue.toString();
        List<? extends Number> vals = DOEUtils.expand(range, field.getAnnotation().type());
        for (Number number : vals) {
            clone = BeansFactory.deepClone(clone);
            DOEUtils.setBeanValue(clone, field, number.toString(), field.getListIndex());
            DOEUtils.expand(clone, orderedFields, index + 1, ret);
        }
    }

    protected static boolean setBeanValue(Object clone, FieldContainer field, String value, int index) throws Exception {
        ArrayList<FieldContainer> fieldPath = new ArrayList<FieldContainer>(3);
        FieldContainer f = field.getParent();
        while (f != null) {
            fieldPath.add(0, f);
            f = f.getParent();
        }
        Object cloneObject = clone;
        for (FieldContainer fc : fieldPath) {
            if (cloneObject instanceof List) {
                int listIndex = field.getParent().getListIndex();
                List cloneList = (List)cloneObject;
                if (listIndex > -1) {
                    cloneObject = cloneList.get(listIndex);
                    continue;
                }
                return false;
            }
            cloneObject = BeansFactory.getBeanValue(cloneObject, fc.getName());
        }
        if (cloneObject instanceof List && index > -1) {
            cloneObject = ((List)cloneObject).get(index);
        }
        if (value != null && value.equals(BeansFactory.getBeanValue(cloneObject, field.getName()))) {
            return false;
        }
        BeansFactory.setBeanValue(cloneObject, field.getName(), value);
        return true;
    }

    public static List<? extends Number> expand(String range) {
        return DOEUtils.expand(range, null);
    }

    public static <T extends Number> List<T> expand(String range, Class<T> clazz) {
        return DOEUtils.expand(range, null, clazz);
    }

    public static List<? extends Number> expand(String range, String unit) {
        return DOEUtils.expand(range, unit, Double.class);
    }

    private static <T extends Number> List<T> expand(String range, String unit, Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>(7);
        if (DOEUtils.isList(range, unit)) {
            String[] items;
            String value = DOEUtils.removeUnit(range, unit);
            String[] stringArray = items = value.split(",");
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                ret.add(DOEUtils.getValue(val.trim(), clazz));
                ++n2;
            }
        } else if (DOEUtils.isRange(range, unit)) {
            double[] ran = DOEUtils.getRange(range, unit);
            if (ran[0] > ran[1]) {
                double i = ran[0];
                while (i >= ran[1]) {
                    if (ret.size() <= 1000) {
                        ret.add(DOEUtils.getValue(i, clazz));
                        i -= ran[2];
                        continue;
                    }
                    break;
                }
            } else {
                double i = ran[0];
                while (i <= ran[1]) {
                    if (ret.size() <= 1000) {
                        ret.add(DOEUtils.getValue(i, clazz));
                        i += ran[2];
                        continue;
                    }
                    break;
                }
            }
        } else {
            String value = DOEUtils.removeUnit(range, unit);
            ret.add(DOEUtils.getValue(value.trim(), clazz));
        }
        return ret;
    }

    public static double[] getRange(String range, String unit) {
        if (!DOEUtils.isRange(range, unit)) {
            return null;
        }
        String value = DOEUtils.removeUnit(range, unit);
        String[] item = value.split(";");
        double start = Double.parseDouble(item[0].trim());
        double end = Double.parseDouble(item[1].trim());
        double inc = Double.parseDouble(item[2].trim());
        return new double[]{start, end, inc};
    }

    private static <T extends Number> T getValue(String val, Class<T> clazz) {
        return DOEUtils.getValue(new Double(val), clazz);
    }

    private static <T extends Number> T getValue(double val, Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)new Integer(Math.round(Math.round(val)));
        }
        if (clazz == Double.class) {
            return (T)new Double(val);
        }
        throw new ClassCastException("DOEUtils cannot expand with class " + clazz + " yet.");
    }

    public static boolean isDOE(String value) {
        return DOEUtils.isRange(value, null) || DOEUtils.isList(value, null);
    }

    public static boolean isRange(String value, String unit) {
        return DOEUtils.isRange(value, 8, unit);
    }

    public static boolean isRange(String value, int decimalPlaces, String unit) {
        Pattern rangePattern = DOEUtils.getRangePattern(decimalPlaces, unit);
        return rangePattern.matcher(value.trim()).matches();
    }

    public static Pattern getRangePattern(int decimalPlaces, String unit) {
        String ndec = decimalPlaces > 0 ? "\\.?\\d{0," + decimalPlaces + "})" : ")";
        String digitExpr = "(\\-?\\d+" + ndec;
        String rangeExpr = "(" + digitExpr + ";\\ ?" + digitExpr + ";\\ ?" + digitExpr + ")";
        if (unit == null) {
            return Pattern.compile(rangeExpr);
        }
        return Pattern.compile(String.valueOf(rangeExpr) + "\\ {1}\\Q" + unit + "\\E");
    }

    public static boolean isList(String value, String unit) {
        return DOEUtils.isList(value, 8, unit);
    }

    public static boolean isList(String value, int decimalPlaces, String unit) {
        Pattern listPattern = DOEUtils.getListPattern(decimalPlaces, unit);
        return listPattern.matcher(value.trim()).matches();
    }

    public static Pattern getListPattern(int decimalPlaces, String unit) {
        String ndec = decimalPlaces > 0 ? "\\.?\\d{0," + decimalPlaces + "})" : ")";
        String digitExpr = "(\\-?\\d+" + ndec;
        String listExpr = "((" + digitExpr + ",\\ ?)+" + digitExpr + ")";
        if (unit == null) {
            return Pattern.compile(listExpr);
        }
        return Pattern.compile(String.valueOf(listExpr) + "\\ {1}\\Q" + unit + "\\E");
    }

    public static String removeUnit(String value, String unit) {
        if (unit == null) {
            return value;
        }
        Pattern pattern = Pattern.compile("(.+)\\ ?\\Q" + unit + "\\E");
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return value;
    }
}

