/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.IRichBean;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class BeansFactory {
    private static final Logger logger = LoggerFactory.getLogger(BeansFactory.class);
    private static Class<? extends IRichBean>[] CLASSES;
    private List<String> classList;

    private static void checkInit() throws NullPointerException {
        if (CLASSES == null) {
            throw new NullPointerException("BeansFactory.CLASSES is null, therefore BeansFactory has not been initialized properly");
        }
    }

    public static IRichBean getBeanObject(String dir, Object beanOrFile) throws Exception {
        BeansFactory.checkInit();
        int i = 0;
        while (i < CLASSES.length) {
            if (CLASSES[i].isInstance(beanOrFile)) {
                return (IRichBean)beanOrFile;
            }
            ++i;
        }
        String path = String.valueOf(dir) + beanOrFile;
        if (!path.endsWith(".xml")) {
            path = String.valueOf(path) + ".xml";
        }
        return BeansFactory.getBean(new File(path));
    }

    public static boolean isBean(File beanFile) throws Exception {
        BeansFactory.checkInit();
        int i = 0;
        while (i < CLASSES.length) {
            if (BeansFactory.isBean(beanFile, CLASSES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IRichBean getBean(File beanFile) throws Exception {
        BeansFactory.checkInit();
        int i = 0;
        while (i < CLASSES.length) {
            if (BeansFactory.isBean(beanFile, CLASSES[i])) {
                return (IRichBean)XMLHelpers.readBean(beanFile, CLASSES[i]);
            }
            ++i;
        }
        return null;
    }

    public static String getXMLString(Object beanOrPath) throws Exception {
        StringWriter writer;
        block8: {
            Object bean = beanOrPath;
            if (beanOrPath instanceof String) {
                bean = BeansFactory.getBean(new File((String)beanOrPath));
            }
            URL mapping = null;
            Field[] fa = bean.getClass().getFields();
            int i = 0;
            while (i < fa.length) {
                if (fa[i].getName().equalsIgnoreCase("mappingurl")) {
                    mapping = (URL)fa[i].get(null);
                }
                ++i;
            }
            writer = new StringWriter();
            try {
                try {
                    XMLHelpers.writeToXML(mapping, bean, writer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    writer.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                writer.close();
                throw throwable;
            }
            writer.close();
        }
        return writer.toString();
    }

    public static void saveBean(File templatePath, Object editingBean) throws Exception {
        URL mapping = null;
        Field[] fa = editingBean.getClass().getFields();
        int i = 0;
        while (i < fa.length) {
            if (fa[i].getName().equalsIgnoreCase("mappingurl")) {
                mapping = (URL)fa[i].get(null);
                break;
            }
            ++i;
        }
        XMLHelpers.writeToXML(mapping, editingBean, templatePath);
    }

    public static String getFirstFileName(File folder, Class<? extends IRichBean> clazz) throws Exception {
        File[] fa = folder.listFiles();
        int i = 0;
        while (i < fa.length) {
            if (BeansFactory.isBean(fa[i], clazz)) {
                return fa[i].getName();
            }
            ++i;
        }
        return null;
    }

    public static boolean isBean(File beanFile, Class<? extends IRichBean> beanClass) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(beanFile));
        return BeansFactory.isBean(reader, beanClass);
    }

    public static boolean isBean(InputStream bean, Class<? extends IRichBean> beanClass) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(bean, "UTF-8"));
        return BeansFactory.isBean(reader, beanClass);
    }

    private static boolean isBean(BufferedReader reader, Class<? extends IRichBean> beanClass) throws Exception {
        try {
            reader.readLine();
            String tagLine = reader.readLine();
            if (tagLine == null) {
                return false;
            }
            String tagName = beanClass.getName().substring(beanClass.getName().lastIndexOf(".") + 1);
            if (tagName == null) {
                return false;
            }
            return tagLine.trim().equalsIgnoreCase("<" + tagName + ">") || tagLine.trim().equalsIgnoreCase("<" + tagName + "/>");
            {
            }
        }
        finally {
            reader.close();
        }
    }

    public static void main(String[] args) throws Exception {
        File testDir = new File("/home/nv23/workspaces/gdatrunk_sep09ws/plugins/uk.ac.gda.client.microfocus/test/uk/ac/gda/client/microfocus/util/TestFiles/");
        File[] fa = testDir.listFiles();
        int i = 0;
        while (i < fa.length) {
            if (!fa[i].isDirectory()) {
                System.out.println(fa[i]);
                IRichBean bean = BeansFactory.getBean(fa[i]);
                if (bean != null) {
                    System.out.println(bean.getClass());
                } else {
                    System.out.println(bean);
                }
            }
            ++i;
        }
    }

    public static Class<? extends IRichBean>[] getClasses() {
        BeansFactory.checkInit();
        return CLASSES;
    }

    public static void setClasses(Class<? extends IRichBean>[] cLASSES) {
        if (cLASSES == null) {
            throw new NullPointerException("cLASSES must be-non null to initialzied BeansFactory");
        }
        CLASSES = cLASSES;
    }

    public List<String> getClassList() {
        return this.classList;
    }

    public void setClassList(List<String> classList) {
        this.classList = classList;
        int i = 0;
        Class[] classes = new Class[classList.size()];
        for (String clazz : classList) {
            try {
                classes[i] = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot load class " + clazz, (Throwable)e);
            }
            ++i;
        }
        BeansFactory.setClasses(classes);
    }

    public static void setBeanValue(Object bean, String fieldName, Object value) throws Exception {
        String setterName = BeansFactory.getSetterName(fieldName);
        try {
            Method method = value != null ? bean.getClass().getMethod(setterName, value.getClass()) : bean.getClass().getMethod(setterName, Object.class);
            method.invoke(bean, value);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            BeanMap properties = new BeanMap(bean);
            properties.put((Object)fieldName, value);
        }
    }

    public static Object getBeanValue(Object bean, String fieldName) throws Exception {
        String getterName = BeansFactory.getGetterName(fieldName);
        Method method = bean.getClass().getMethod(getterName, new Class[0]);
        return method.invoke(bean, new Object[0]);
    }

    public static String getFieldWithUpperCaseFirstLetter(String fieldName) {
        return String.valueOf(fieldName.substring(0, 1).toUpperCase(Locale.US)) + fieldName.substring(1);
    }

    private static String getName(String prefix, String fieldName) {
        return String.valueOf(prefix) + BeansFactory.getFieldWithUpperCaseFirstLetter(fieldName);
    }

    public static String getSetterName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return BeansFactory.getName("set", fieldName);
    }

    public static String getGetterName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return BeansFactory.getName("get", fieldName);
    }

    public static boolean isClass(Class<? extends IRichBean> clazz) {
        BeansFactory.checkInit();
        int i = 0;
        while (i < CLASSES.length) {
            if (CLASSES[i].equals(clazz)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> T deepClone(T fromBean) throws Exception {
        return BeansFactory.deepClone(fromBean, fromBean.getClass().getClassLoader());
    }

    public static <T> T deepClone(T toClone, final ClassLoader classLoader) throws Exception {
        if (toClone == null) {
            return null;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(toClone);
        oOut.close();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        bOut.close();
        ObjectInputStream oIn = new ObjectInputStream(bIn){

            /*
             * Unable to fully structure code
             */
            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(desc.getName(), false, classLoader);
                }
                catch (Exception v0) {
                    i = 0;
                    ** while (i < BeansFactory.access$0().length)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        return BeansFactory.access$0()[i].getClassLoader().loadClass(desc.getName());
                    }
                    catch (Exception v1) {
                        ++i;
                    }
                    continue;
                }
lbl11:
                // 1 sources

                return null;
            }
        };
        bIn.close();
        Object copy = oIn.readObject();
        oIn.close();
        return (T)copy;
    }

    static /* synthetic */ Class[] access$0() {
        return CLASSES;
    }
}

