/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.junit.Assume;

public class TestUtils {
    public static final String OUTPUT_FOLDER_PREFIX = "test-scratch/";

    public static void skipTestIf(boolean condition, String reason) {
        if (condition) {
            System.out.println("JUnit test skipped: " + reason);
            Assume.assumeTrue((boolean)false);
        }
    }

    public static void skipTest(String reason) {
        System.out.println("JUnit test skipped: " + reason);
        Assume.assumeTrue((boolean)false);
    }

    public static String generateDirectorynameFromClassname(String classname) {
        return OUTPUT_FOLDER_PREFIX + classname.replace('.', '/') + '/';
    }

    static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                boolean success = TestUtils.deleteDir(new File(dir, element));
                if (!success) {
                    System.out.println("1. deleteDir could not delete: " + new File(dir, element));
                    return false;
                }
                ++n2;
            }
        }
        if (dir.delete()) {
            return true;
        }
        System.out.println("2. deleteDir could not delete: " + dir + ". Make sure each test creates a uniquely named folder. Otherwise stale NFS locks may prevent folder deletion.");
        return false;
    }

    public static File createClassScratchDirectory(Class<?> clazz) {
        File dir = new File(TestUtils.generateDirectorynameFromClassname(clazz.getCanonicalName()));
        dir.mkdirs();
        return dir;
    }

    public static void makeScratchDirectory(String testScratchDirectoryname) throws Exception {
        if (!TestUtils.deleteDir(new File(testScratchDirectoryname))) {
            throw new Exception("Unable to delete old test scratch directory " + testScratchDirectoryname);
        }
        if (!new File(testScratchDirectoryname).mkdirs()) {
            throw new Exception("Unable to create new test scratch directory " + testScratchDirectoryname);
        }
    }

    public static File getResourceAsFile(Class<?> clazz, String name) throws FileNotFoundException {
        URL url = clazz.getResource(name);
        if (url == null) {
            throw new FileNotFoundException(String.valueOf(name) + " (resource not found)");
        }
        return new File(url.getFile());
    }

    public static String setUpTest(Class<?> testClass, String nameOfTest, boolean makedir) throws Exception {
        String name = testClass.getCanonicalName();
        if (name == null) {
            throw new IllegalArgumentException("getCanonicalName failed for class " + testClass.toString());
        }
        String testScratchDirectoryName = String.valueOf(TestUtils.generateDirectorynameFromClassname(testClass.getCanonicalName())) + nameOfTest;
        if (makedir) {
            TestUtils.makeScratchDirectory(testScratchDirectoryName);
        }
        return testScratchDirectoryName;
    }

    public static String getGDALargeTestFilesLocation() {
        return System.getProperty("GDALargeTestFilesLocation");
    }
}

