/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCommandRunner
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(OSCommandRunner.class);
    public final Integer exitValue;
    public final Exception exception;
    public final Boolean succeeded;
    public final List<String> commands;
    public final boolean keepOutput;
    private final List<String> outputLines;

    public final List<String> getOutputLines() {
        return this.outputLines;
    }

    public OSCommandRunner(String[] _commands, boolean _keepOutput, String stdInFileName, String stdOutFileName) {
        this(Arrays.asList(_commands), _keepOutput, stdInFileName, stdOutFileName, null, null);
    }

    public OSCommandRunner(String command, boolean _keepOutput, String stdInFileName, String stdOutFileName) {
        this(Arrays.asList(command.split("[\\s]")), _keepOutput, stdInFileName, stdOutFileName, null, null);
    }

    public static void runNoWait(String command, LOGOPTION logOption, String stdInFileName) {
        OSCommandRunner.runNoWait(Arrays.asList(command.split("[\\s]")), logOption, stdInFileName);
    }

    public static void runNoWait(String[] _commands, LOGOPTION logOption, String stdInFileName) {
        OSCommandRunner.runNoWait(Arrays.asList(_commands), logOption, stdInFileName);
    }

    public static void runNoWait(List<String> _commands, LOGOPTION logOption, String stdInFileName) {
        OSCommandRunner.runNoWait(_commands, logOption, stdInFileName, null, null);
    }

    public static void runNoWait(List<String> _commands, LOGOPTION logOption, String stdInFileName, ExecutorService executor) {
        OSCommandRunner._runNoWait(_commands, logOption, stdInFileName, null, null, executor);
    }

    public static void runNoWait(List<String> _commands, LOGOPTION logOption, String stdInFileName, Map<? extends String, ? extends String> envPutAll, List<String> envRemove) {
        OSCommandRunner._runNoWait(_commands, logOption, stdInFileName, envPutAll, envRemove, null);
    }

    private static void _runNoWait(final List<String> _commands, final LOGOPTION logOption, final String stdInFileName, final Map<? extends String, ? extends String> envPutAll, final List<String> envRemove, ExecutorService executor) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                OSCommandRunner osCommandRunner = new OSCommandRunner(_commands, logOption != LOGOPTION.NEVER, stdInFileName, null, envPutAll, envRemove);
                if (osCommandRunner.exception != null) {
                    String msg = "Exception seen trying to run command " + osCommandRunner.getCommandAsString();
                    logger.error(msg);
                    logger.error(osCommandRunner.exception.toString());
                } else if (osCommandRunner.exitValue != 0) {
                    String msg = "Exit code = " + Integer.toString(osCommandRunner.exitValue) + " returned from command " + osCommandRunner.getCommandAsString();
                    logger.warn(msg);
                    if (logOption != LOGOPTION.NEVER) {
                        osCommandRunner.logOutput();
                    }
                } else if (logOption == LOGOPTION.ALWAYS) {
                    osCommandRunner.logOutput();
                }
            }
        };
        if (executor != null) {
            executor.submit(r);
        } else {
            new Thread(r, OSCommandRunner.class.getSimpleName()).start();
        }
    }

    public OSCommandRunner(List<String> _commands, boolean _keepOutput, Object stdInFile, String stdOutFileName) {
        this(_commands, _keepOutput, stdInFile, stdOutFileName, null, null);
    }

    public OSCommandRunner(List<String> _commands, boolean _keepOutput, Object stdInFile, String stdOutFileName, Map<? extends String, ? extends String> envPutAll, List<String> envRemove) {
        this(_commands, _keepOutput, stdInFile, stdOutFileName, envPutAll, envRemove, null);
    }

    public OSCommandRunner(List<String> _commands, boolean _keepOutput, Object stdInFile, String stdOutFileName, Map<? extends String, ? extends String> envPutAll, List<String> envRemove, String directory) {
        block30: {
            this.commands = _commands;
            this.keepOutput = _keepOutput;
            Integer _exitValue = 0;
            Exception _exception = null;
            Boolean _succeeded = false;
            Vector<String> _outputLines = null;
            try {
                try {
                    byte[] buffer;
                    InputStream istream;
                    ProcessBuilder pb = new ProcessBuilder(new String[0]);
                    if (envRemove != null) {
                        for (String key : envRemove) {
                            pb.environment().remove(key);
                        }
                    }
                    if (envPutAll != null) {
                        pb.environment().putAll(envPutAll);
                    }
                    pb.redirectErrorStream(true);
                    pb.command(this.commands);
                    if (directory != null && !directory.isEmpty()) {
                        pb.directory(new File(directory));
                    }
                    Process p = pb.start();
                    if (stdInFile != null) {
                        OutputStream ostream = p.getOutputStream();
                        istream = stdInFile instanceof String ? new FileInputStream((String)stdInFile) : null;
                        try {
                            buffer = new byte[4096];
                            if (istream != null) {
                                int count = 0;
                                while ((count = istream.read(buffer)) >= 0) {
                                    ostream.write(buffer, 0, count);
                                }
                            } else {
                                String[] lines = (String[])stdInFile;
                                int i = 0;
                                while (i < lines.length) {
                                    ostream.write(lines[i].getBytes("UTF-8"));
                                    ostream.write(10);
                                    ++i;
                                }
                            }
                        }
                        catch (IOException iOException) {}
                        ostream.close();
                        if (istream != null) {
                            istream.close();
                        }
                    }
                    if (!this.keepOutput && stdOutFileName == null) {
                        OSCommandRunner.pipe(p.getInputStream(), System.out);
                    }
                    _exitValue = p.waitFor();
                    if (stdOutFileName != null) {
                        InputStream istream2 = p.getInputStream();
                        FileOutputStream ostream = new FileOutputStream(stdOutFileName);
                        buffer = new byte[4096];
                        int count = 0;
                        while ((count = istream2.read(buffer)) >= 0) {
                            ((OutputStream)ostream).write(buffer, 0, count);
                        }
                        ((OutputStream)ostream).close();
                    }
                    if (this.keepOutput) {
                        BufferedReader output = null;
                        istream = null;
                        try {
                            String line;
                            istream = stdOutFileName != null ? new FileInputStream(stdOutFileName) : p.getInputStream();
                            output = new BufferedReader(new InputStreamReader(istream));
                            _outputLines = new Vector<String>();
                            while ((line = output.readLine()) != null) {
                                _outputLines.add(line);
                            }
                        }
                        finally {
                            if (stdOutFileName != null && istream != null) {
                                istream.close();
                            }
                        }
                    }
                    _succeeded = _exitValue == 0;
                    OSCommandRunner.closeStream(p.getInputStream(), "input");
                    OSCommandRunner.closeStream(p.getOutputStream(), "output");
                    OSCommandRunner.closeStream(p.getErrorStream(), "error");
                    p.destroy();
                }
                catch (Exception ex) {
                    this.exception = _exception = ex;
                    this.exitValue = _exitValue;
                    this.succeeded = _succeeded;
                    if (_outputLines != null) {
                        this.outputLines = _outputLines;
                        break block30;
                    }
                    this.outputLines = null;
                }
            }
            finally {
                this.exception = _exception;
                this.exitValue = _exitValue;
                this.succeeded = _succeeded;
                this.outputLines = _outputLines != null ? _outputLines : null;
            }
        }
    }

    private static void closeStream(Closeable stream, String name) {
        try {
            stream.close();
        }
        catch (IOException ioe) {
            logger.warn(String.format("Unable to close process %s stream", name), (Throwable)ioe);
        }
    }

    private static void pipe(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        dest.write(buffer, 0, n);
                        n = src.read(buffer);
                    }
                }
                catch (IOException iOException) {}
            }
        }).start();
    }

    public String getCommandAsString() {
        String msg = "";
        for (String s : this.commands) {
            msg = String.valueOf(msg) + " " + s;
        }
        return msg;
    }

    public void logOutput() {
        logger.info("Output from command " + this.getCommandAsString());
        if (this.outputLines != null) {
            for (String s : this.outputLines) {
                logger.info(s);
            }
        }
    }

    public static enum LOGOPTION {
        NEVER,
        ALWAYS,
        ONLY_ON_ERROR;

    }
}

