/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.junit.Test;
import uk.ac.gda.util.CorrectionUtils;
import uk.ac.gda.util.PackageUtils;
import uk.ac.gda.util.number.DoubleUtils;

public class CorrectionTest {
    @Test
    public void testCorrectionFactorCalculation() throws Exception {
        File data = new File(String.valueOf(PackageUtils.getTestPath(this.getClass(), "test")) + "43490.dat");
        File corr = new File(String.valueOf(PackageUtils.getTestPath(this.getClass(), "test")) + "43490_corr.dat");
        BufferedReader dat = new BufferedReader(new FileReader(data));
        BufferedReader cor = new BufferedReader(new FileReader(corr));
        double[] fit = new double[]{1.1029752060937018E-7, 1.1407794527246737E-7, 1.1465765791909203E-7, 1.0675602460939456E-7};
        try {
            String line = null;
            while ((line = dat.readLine()) != null) {
                String[] d = line.split(" ");
                if (d.length != 19) {
                    throw new Exception("Expected 19 columns in the data!");
                }
                double[] k = new double[4];
                int i = 0;
                while (i < k.length) {
                    double ffr = Double.parseDouble(d[11 + i]);
                    double sfr = Double.parseDouble(d[15 + i]);
                    k[i] = CorrectionUtils.getK(fit[i], ffr, sfr);
                    ++i;
                }
                String correctedLine = cor.readLine();
                String[] c = correctedLine.split(" ");
                int i2 = 0;
                while (i2 < k.length) {
                    double windowOrig = Double.parseDouble(d[6 + i2]);
                    if (DoubleUtils.equalsWithinTolerance(windowOrig * k[i2], Double.parseDouble(c[6 + i2]), 1.0E-4)) {
                        throw new Exception("The correction factor '" + k[i2] + "' when applied to '" + windowOrig + "' gives '" + windowOrig * k[i2] + "' not '" + Double.parseDouble(c[6 + i2]) + "'");
                    }
                    ++i2;
                }
            }
        }
        finally {
            dat.close();
            cor.close();
        }
    }
}

