/*
 * Decompiled with CFR 0.152.
 */
package gda.observable;

import gda.observable.IIsBeingObserved;
import gda.observable.IObservable;
import gda.observable.IObserver;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableComponent
implements IObservable,
IIsBeingObserved {
    private Vector<IObserver> myIObservers = new Vector();
    private static final Logger logger = LoggerFactory.getLogger(ObservableComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIObserver(IObserver anIObserver) {
        Vector<IObserver> vector = this.myIObservers;
        synchronized (vector) {
            if (!this.myIObservers.contains(anIObserver)) {
                this.myIObservers.addElement(anIObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIObserver(IObserver anIObserver) {
        Vector<IObserver> vector = this.myIObservers;
        synchronized (vector) {
            this.myIObservers.removeElement(anIObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIObservers() {
        Vector<IObserver> vector = this.myIObservers;
        synchronized (vector) {
            this.myIObservers.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIObservers(Object theObserved, Object changeCode) {
        IObserver[] observers;
        Vector<IObserver> vector = this.myIObservers;
        synchronized (vector) {
            observers = this.myIObservers.toArray(new IObserver[0]);
        }
        IObserver[] iObserverArray = observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            IObserver anIObserver = iObserverArray[n2];
            try {
                anIObserver.update(theObserved, changeCode);
            }
            catch (Exception ex) {
                logger.error("notifyIObservers of " + theObserved.toString(), (Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public boolean IsBeingObserved() {
        return !this.myIObservers.isEmpty();
    }
}

