/*
 * Decompiled with CFR 0.152.
 */
package gda.doe;

import gda.doe.TestBean;
import gda.doe.TestContainer;
import gda.doe.TestContainerContainer;
import gda.doe.TestContainerList;
import gda.doe.TestDimsData;
import gda.doe.TestDimsDataList;
import gda.doe.TestList;
import gda.doe.TestListOneAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Test;
import uk.ac.gda.doe.DOEUtils;

public class DOETest {
    @Test
    public void testFieldWeightings() throws Throwable {
        int j;
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        List<? extends Object> os = DOEUtils.expand(t);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
        ArrayList<TestBean> compare = new ArrayList<TestBean>(27);
        int k = 1;
        while (k < 4) {
            j = 1;
            while (j < 4) {
                int i = 1;
                while (i < 4) {
                    compare.add(new TestBean(String.valueOf(i), String.valueOf(j) + ".0", String.valueOf(k) + ".0"));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        if (!os.equals(compare)) {
            throw new Exception("Expansion did not process weightings correctly!");
        }
        compare.clear();
        int i = 1;
        while (i < 4) {
            j = 1;
            while (j < 4) {
                int k2 = 1;
                while (k2 < 4) {
                    compare.add(new TestBean(String.valueOf(i), String.valueOf(j) + ".0", String.valueOf(k2) + ".0"));
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        if (os.equals(compare)) {
            throw new Exception("Expansion did not process weightings correctly!");
        }
    }

    @Test
    public void testNested1() throws Throwable {
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        List<? extends Object> os = DOEUtils.expand(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNested2() throws Throwable {
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        TestContainerContainer r = new TestContainerContainer();
        r.setTestContainer(c);
        List<? extends Object> os = DOEUtils.expand(r);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList1() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0");
        t.setJ("4.0");
        t.setK("4.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() == 2) continue;
            throw new Exception("There should only be 2 items in the TestList object.");
        }
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2a() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0");
        t.setJ("4.0");
        t.setK("4.0");
        beans.add(t);
        t = new TestBean();
        t.setI("1.0");
        t.setJ("2.0");
        t.setK("3.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() == 3) continue;
            throw new Exception("There should only be 2 items in the TestList object.");
        }
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2b() throws Throwable {
        TestList c = new TestList();
        c.add(new TestBean(0));
        c.add(new TestBean(1));
        TestBean t = new TestBean();
        t.setK("100;200;1");
        c.add(t);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() == 3) continue;
            throw new Exception("There should only be 3 items in the TestList object.");
        }
        if (os.size() != 101) {
            throw new Exception("Should give 101 experiments!");
        }
    }

    @Test
    public void testNestedList2c() throws Throwable {
        TestListOneAnnotation c = new TestListOneAnnotation();
        c.add(new TestDimsData(0));
        c.add(new TestDimsData(1));
        TestDimsData t = new TestDimsData(2);
        t.setSliceRange("100;200;1");
        c.add(t);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestListOneAnnotation tl = (TestListOneAnnotation)object;
            if (tl.getTestBeans().size() == 3) continue;
            throw new Exception("There should only be 3 items in the TestList object.");
        }
        if (os.size() != 101) {
            throw new Exception("Should give 101 experiments!");
        }
    }

    @Test
    public void testNestedList2d() throws Throwable {
        TestDimsDataList c = new TestDimsDataList();
        c.add(new TestDimsData(0));
        c.add(new TestDimsData(1));
        TestDimsData t = new TestDimsData(2);
        t.setSliceRange("100;200;1");
        c.add(t);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestDimsDataList tl = (TestDimsDataList)object;
            if (tl.size() == 3) continue;
            throw new Exception("There should only be 3 items in the TestList object.");
        }
        if (os.size() != 101) {
            throw new Exception("Should give 101 experiments!");
        }
    }

    @Test
    public void testNestedList3() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0;4.5;1.0");
        t.setJ("4.0;4.5;1.0");
        t.setK("4.0;4.5;1.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() != 2) {
                throw new Exception("There should only be 2 items in the TestList object.");
            }
            for (TestBean tb : tl.getTestBeans()) {
                if (DOEUtils.isDOE(tb.getI())) {
                    throw new Exception("TestBean found not to have expanded range! " + tb);
                }
                if (DOEUtils.isDOE(tb.getJ())) {
                    throw new Exception("TestBean found not to have expanded range! " + tb);
                }
                if (!DOEUtils.isDOE(tb.getK())) continue;
                throw new Exception("TestBean found not to have expanded range! " + tb);
            }
        }
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList4() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0;5;1.0");
        t.setJ("4.0;5;1.0");
        t.setK("4.0;5;1.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() == 2) continue;
            throw new Exception("There should only be 2 items in the TestList object.");
        }
        if (os.size() != 216) {
            throw new Exception("Three parameters, each with three values should give 216 experiments!");
        }
    }

    @Test
    public void testNestedList5() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0");
        t.setJ("4.0");
        t.setK("4.0");
        beans.add(t);
        t = new TestBean();
        t.setI("5.0");
        t.setJ("5.0");
        t.setK("5.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<? extends Object> os = DOEUtils.expand(c);
        for (Object object : os) {
            TestList tl = (TestList)object;
            if (tl.getTestBeans().size() == 3) continue;
            throw new Exception("There should only be 3 items in the TestList object.");
        }
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedListContainer() throws Throwable {
        ArrayList<TestContainer> tcl = new ArrayList<TestContainer>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        tcl.add(c);
        TestContainerList cl = new TestContainerList();
        cl.setTestContainers(tcl);
        List<? extends Object> os = DOEUtils.expand(cl);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testInt() throws Throwable {
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        List<? extends Object> os = DOEUtils.expand(t);
        TestBean b = (TestBean)os.get(0);
        if (b.getI().equals("1.0")) {
            throw new Exception("i is marked as an integer and it should be '1' not '1.0' for the first bean.");
        }
    }

    @Test
    public void testPatterns() throws Throwable {
        Pattern pattern = DOEUtils.getListPattern(5, null);
        if (pattern.matcher("3.22").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("295.0, 300.12").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33,5.44").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3,4.3,5.4454").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3, 4.3, 5.4454, 4").matches()) {
            throw new Exception();
        }
        pattern = DOEUtils.getListPattern(5, "fred");
        if (pattern.matcher("3.22 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33,5.44 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3,4.3,5.4454 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3, 4.3, 5.4454, 4 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (!DOEUtils.removeUnit("3.22,4.33 fred", "fred").trim().equals("3.22,4.33")) {
            throw new Exception();
        }
        pattern = DOEUtils.getRangePattern(5, "fred");
        if (pattern.matcher("3.22 fred").matches()) {
            throw new Exception();
        }
        if (pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (pattern.matcher("3.22,4.33,5.44 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("4.3;5.4454;1 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3; 4.3; 0.1 fred").matches()) {
            throw new Exception();
        }
    }
}

