/*
 * Decompiled with CFR 0.152.
 */
package gda.doe;

import gda.doe.TestBean;
import gda.doe.TestContainer;
import gda.doe.TestContainerContainer;
import gda.doe.TestContainerList;
import gda.doe.TestList;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.doe.RangeInfo;

public class DOEInfoTest {
    @Test
    public void testNested1() throws Throwable {
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
        System.out.println(RangeInfo.format(os));
    }

    @Test
    public void testNested2() throws Throwable {
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        TestContainerContainer r = new TestContainerContainer();
        r.setTestContainer(c);
        List<RangeInfo> os = DOEUtils.getInfo(r);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList1() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0");
        t.setJ("4.0");
        t.setK("4.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList3() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0;4.5;1.0");
        t.setJ("4.0;4.5;1.0");
        t.setK("4.0;4.5;1.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList4() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0;5;1.0");
        t.setJ("4.0;5;1.0");
        t.setK("4.0;5;1.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 216) {
            throw new Exception("Three parameters, each with three values should give 216 experiments!");
        }
    }

    @Test
    public void testNestedList5() throws Throwable {
        ArrayList<TestBean> beans = new ArrayList<TestBean>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        beans.add(t);
        t = new TestBean();
        t.setI("4.0");
        t.setJ("4.0");
        t.setK("4.0");
        beans.add(t);
        t = new TestBean();
        t.setI("5.0");
        t.setJ("5.0");
        t.setK("5.0");
        beans.add(t);
        TestList c = new TestList();
        c.setTestBeans(beans);
        List<RangeInfo> os = DOEUtils.getInfo(c);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedListContainer() throws Throwable {
        ArrayList<TestContainer> tcl = new ArrayList<TestContainer>(2);
        TestBean t = new TestBean();
        t.setI("1;3;1");
        t.setJ("1;3;1");
        t.setK("1;3;1");
        TestContainer c = new TestContainer();
        c.setTestBean(t);
        tcl.add(c);
        TestContainerList cl = new TestContainerList();
        cl.setTestContainers(tcl);
        List<RangeInfo> os = DOEUtils.getInfo(cl);
        if (os.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }
}

