/*
 * Decompiled with CFR 0.152.
 */
package gda.configuration.properties;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XmlDomFactory {
    private static final Logger logger = LoggerFactory.getLogger(XmlDomFactory.class);
    private static final String DOM_IMPL_PROPERTY = "org.w3c.dom.DOMImplementationClass";
    private static DOMImplementation domImpl = null;

    public static DOMImplementation getDomImpl() {
        if (domImpl != null) {
            return domImpl;
        }
        String domImplPropertyValue = System.getProperty(DOM_IMPL_PROPERTY);
        if (domImplPropertyValue != null) {
            try {
                domImpl = (DOMImplementation)Class.forName(domImplPropertyValue).newInstance();
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
                logger.debug(e.getStackTrace().toString());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
                logger.debug(e.getStackTrace().toString());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
                logger.debug(e.getStackTrace().toString());
            }
        } else {
            try {
                domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            }
            catch (ParserConfigurationException e) {
                logger.error(e.getMessage());
                logger.debug(e.getStackTrace().toString());
            }
        }
        return domImpl;
    }

    public static DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        if (domImpl == null) {
            XmlDomFactory.getDomImpl();
        }
        if (domImpl != null) {
            DocumentType docType = domImpl.createDocumentType(qualifiedName, publicId, systemId);
            return docType;
        }
        return null;
    }

    public static Document createDocument(String nameSpaceURI, String qualifiedName, DocumentType docType) {
        if (domImpl == null) {
            XmlDomFactory.getDomImpl();
        }
        Document theDocument = null;
        if (domImpl != null) {
            try {
                theDocument = domImpl.createDocument(nameSpaceURI, qualifiedName, docType);
            }
            catch (DOMException e) {
                logger.error(e.getMessage());
                logger.debug(e.getStackTrace().toString());
            }
        }
        return theDocument;
    }
}

