/*
 * Decompiled with CFR 0.152.
 */
package gda.configuration.properties;

import gda.configuration.properties.XmlDomFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PropertiesToXmlConverter {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesToXmlConverter.class);
    private Properties props = null;
    private Document doc = null;
    private Element root = null;
    private static final String prependString = "A";

    private Element getChild(Element current, String childName) {
        NodeList nodeList = current.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeName().equals(childName)) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    private void addChildSortedAlphabetically(Element current, Element newChild) {
        NodeList nodeList = current.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeName().compareToIgnoreCase(newChild.getNodeName()) > 0) {
                current.insertBefore(newChild, n);
                return;
            }
            ++i;
        }
        current.appendChild(newChild);
    }

    private void addPropertyToXmlDomRepresentation(Element root, String propertyName, String propertyValue) {
        int split;
        String name = propertyName;
        Element current = root;
        Element test = null;
        while ((split = name.indexOf(".")) != -1) {
            String subName = name.substring(0, split);
            name = name.substring(split + 1);
            test = this.getChild(current, subName);
            if (test == null) {
                Element subElement = this.doc.createElement(subName);
                this.addChildSortedAlphabetically(current, subElement);
                current = subElement;
                continue;
            }
            current = test;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c)) {
            logger.debug("Found non-alpha first-character in last segment of property: " + propertyName + " (" + name + ")");
            logger.debug("Converting to: A" + name);
            logger.debug("");
            name = prependString + name;
        }
        Element last = null;
        Text valueTextNode = null;
        try {
            last = this.doc.createElement(name);
            valueTextNode = this.doc.createTextNode(propertyValue);
            last.appendChild(valueTextNode);
            this.addChildSortedAlphabetically(current, last);
        }
        catch (DOMException e) {
            logger.error(e.getMessage());
        }
    }

    private void writeDomToXmlFileTransform(String outputFileName) {
        String encoding = "UTF-8";
        int indentAmount = 3;
        Transformer t = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(indentAmount));
            t = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            logger.error(e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error(e.getMessage());
        }
        if (t == null) {
            logger.error("writeDomToXmlFileXalan failed - could not create Transformer");
            return;
        }
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("version", "1.0");
        t.setOutputProperty("encoding", encoding);
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("omit-xml-declaration", "no");
        t.setOutputProperty("media-type", "text/xml");
        DOMSource s = new DOMSource(this.doc);
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), encoding);
            StreamResult r = new StreamResult(out);
            t.transform(s, r);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
        }
        catch (TransformerException e) {
            logger.error(e.getMessage());
        }
    }

    private void writeDomToXmlFile(String outputFileName) {
        this.writeDomToXmlFileTransform(outputFileName);
    }

    private void convertPropertiesToXml() {
        this.doc = XmlDomFactory.createDocument(null, "root", null);
        this.root = this.doc.getDocumentElement();
        Enumeration<?> propertyNames = this.props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String value = this.props.getProperty(name);
            this.addPropertyToXmlDomRepresentation(this.root, name, value);
        }
    }

    private void loadPropertiesFile(String inputFileName) {
        try {
            FileInputStream f = new FileInputStream(inputFileName);
            this.props = new Properties();
            this.props.load(f);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            logger.error("could not load input file: " + inputFileName);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            logger.error("could not create properties object from input file: " + inputFileName);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("could not create properties object from input file: " + inputFileName);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            logger.info("Usage: java gda.configuration.properties.PropertiesToXmlConverter [properties file] [XML file for output]");
            System.exit(0);
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        try {
            PropertiesToXmlConverter converter = new PropertiesToXmlConverter();
            converter.loadPropertiesFile(inputFileName);
            if (converter.props != null) {
                converter.convertPropertiesToXml();
                converter.writeDomToXmlFile(outputFileName);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.debug(e.getStackTrace().toString());
        }
    }
}

