/*
 * Decompiled with CFR 0.152.
 */
package gda.configuration.properties;

import gda.configuration.properties.JakartaPropertiesConfig;
import gda.configuration.properties.PropertiesConfig;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LocalProperties {
    private static final Logger logger;
    public static final String GDA_ROOT = "gda.root";
    public static final String GDA_DATA = "gda.data";
    public static final String GDA_DATAWRITER_DIR = "gda.data.scan.datawriter.datadir";
    public static final String GDA_DATA_NUMTRACKER = "gda.data.numtracker";
    public static final String GDA_CONFIG = "gda.config";
    public static final String GDA_VAR_DIR = "gda.var";
    public static final String GDA_LOGS_DIR = "gda.logs.dir";
    public static final String GDA_PROPERTIES_FILE = "gda.propertiesFile";
    public static final String GDA_PROPERTIES_FILES = "gda.propertiesFiles";
    public static final String GDA_FACTORY_NAME = "gda.factory.factoryName";
    public static final String GDA_OE_FACTORY = "gda.oe.oefactory";
    public static final String GDA_ACCESS_CONTROL_ENABLED = "gda.accesscontrol.useAccessControl";
    public static final String GDA_BATON_MANAGEMENT_ENABLED = "gda.accesscontrol.useBatonControl";
    public static final String GDA_OBJECTSERVER_XML = "gda.objectserver.xml";
    public static final String GDA_SCANNABLEBASE_POLLTIME = "gda.scannablebase.polltime.millis";
    public static final String GDA_GUI_XML = "gda.gui.xml";
    public static final String GDA_GUI_BEANS_XML = "gda.gui.beans.xml";
    public static final String GDA_IMAGES_DISPLAY_CONFIG_FILE = "gda.images.displayConfigFile";
    public static final String GDA_IMAGES_SINGLE_BEAM_CENTRE = "gda.images.SingleBeamCenter";
    public static final String GDA_BEAMLINE_NAME = "gda.beamline.name";
    public static final String GDA_IMAGES_HORIZONTAL_DIRECTION = "gda.images.horizontaldirection";
    public static final String GDA_PX_SAMPLE_CONTROL_AXIS_ORIENTATION = "gda.px.samplecontrol.axisorientation";
    public static final String GDA_PX_SAMPLE_CONTROL_OMEGA_DIRECTION = "gda.px.samplecontrol.omegadirection";
    public static final String GDA_PX_SAMPLE_CONTROL_ALLOW_BEAM_AXIS_MOVEMENT = "gda.px.samplecontrol.allowbeamaxismovement";
    public static final String GDA_DEF_VISIT = "gda.defVisit";
    public static final String RCP_APP_VISIT = "gda.rcp.application.this.visit";
    public static final String RCP_APP_USER = "gda.rcp.application.this.user";
    public static final String GDA_DATA_NUMTRACKER_EXTENSION = "gda.data.numtracker.extension";
    public static final String GDA_SCAN_MULTITHREADED_SCANDATA_POINT_PIPElINE_LENGTH = "gda.scan.multithreadedScanDataPointPipeline.length";
    public static final String GDA_SCAN_MULTITHREADED_SCANDATA_POINT_PIPElINE_POINTS_TO_COMPUTE_SIMULTANEOUSELY = "gda.scan.multithreadedScanDataPointPipeline.pointsToComputeSimultaneousely";
    private static PropertiesConfig propConfig;

    static {
        File testExists;
        logger = LoggerFactory.getLogger(LocalProperties.class);
        propConfig = new JakartaPropertiesConfig();
        String propertiesFiles = propConfig.getString(GDA_PROPERTIES_FILES, null);
        if (propertiesFiles == null || propertiesFiles.isEmpty()) {
            propertiesFiles = propConfig.getString(GDA_PROPERTIES_FILE, null);
        }
        if (propertiesFiles == null || propertiesFiles.isEmpty()) {
            propertiesFiles = String.valueOf(LocalProperties.getConfigDir()) + System.getProperty("file.separator") + "properties" + System.getProperty("file.separator") + "java.properties";
        }
        if (!(testExists = new File(propertiesFiles)).exists()) {
            logger.warn("Neither gda.propertiesFiles nor gda.propertiesFile is set and " + propertiesFiles + " does not exist - no properties are available");
        } else {
            StringTokenizer st = new StringTokenizer(propertiesFiles, " ");
            while (st.hasMoreTokens()) {
                String propertiesFile = st.nextToken();
                try {
                    propConfig.loadPropertyData(propertiesFile);
                }
                catch (ConfigurationException ex) {
                    throw new IllegalArgumentException("Error loading " + propertiesFile, ex);
                }
            }
        }
    }

    public static void parseProperties(String[] propertyPairs) {
        int i = 0;
        while (i < propertyPairs.length) {
            String propertyName = null;
            String propertyValue = null;
            StringTokenizer st = new StringTokenizer(propertyPairs[i], "=");
            if (st.hasMoreTokens()) {
                propertyName = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                propertyValue = st.nextToken();
            }
            if (propertyName != null && propertyValue != null) {
                propConfig.setString(propertyValue, propertyName);
            }
            ++i;
        }
    }

    public static String get(String propertyName) {
        String propertyValue = null;
        propertyValue = propConfig.getString(propertyName, null);
        if (propertyValue != null) {
            propertyValue = propertyValue.replace('\\', '/');
        }
        return propertyValue;
    }

    public static boolean check(String propertyName) {
        return LocalProperties.check(propertyName, false);
    }

    public static boolean check(String propertyName, boolean defaultCheck) {
        return propConfig.getBoolean(propertyName, defaultCheck);
    }

    public static int getInt(String propertyName, int defaultValue) {
        return propConfig.getInteger(propertyName, defaultValue);
    }

    public static double getDouble(String propertyName, double defaultValue) {
        return propConfig.getDouble(propertyName, defaultValue);
    }

    public static String get(String propertyName, String defaultValue) {
        String value = propConfig.getString(propertyName, defaultValue);
        if (value != null) {
            value = value.replace('\\', '/');
        }
        return value;
    }

    public static String getPath(String name, String defaultValue) {
        return propConfig.getPath(name, defaultValue);
    }

    public static URL getURL(String name, URL defaultValue) {
        return propConfig.getURL(name, defaultValue);
    }

    public static void set(String propertyName, String value) {
        propConfig.setString(value, propertyName);
    }

    public static boolean isAccessControlEnabled() {
        return LocalProperties.check(GDA_ACCESS_CONTROL_ENABLED, false);
    }

    public static boolean isBatonManagementEnabled() {
        return LocalProperties.check(GDA_BATON_MANAGEMENT_ENABLED, false);
    }

    public static String getCoreLibraryDirectory() {
        return String.valueOf(LocalProperties.getRoot()) + "/uk.ac.gda.core/lib/";
    }

    public static String getRoot() {
        return LocalProperties.appendSeparator(LocalProperties.get(GDA_ROOT));
    }

    public static String getConfigDir() {
        return LocalProperties.appendSeparator(LocalProperties.get(GDA_CONFIG));
    }

    private static String appendSeparator(String file) {
        if (file == null || file.isEmpty()) {
            return file;
        }
        if (!file.endsWith(System.getProperty("file.separator"))) {
            return String.valueOf(file) + System.getProperty("file.separator");
        }
        return file;
    }

    public static String getVarDir() {
        String gda_var = LocalProperties.appendSeparator(LocalProperties.get(GDA_VAR_DIR));
        if (gda_var == null) {
            gda_var = String.valueOf(LocalProperties.getConfigDir()) + "/var";
        }
        return LocalProperties.appendSeparator(gda_var);
    }

    public static String getBaseDataDir() {
        return LocalProperties.appendSeparator(LocalProperties.get(GDA_DATA));
    }

    public static List<Integer> stringToIntList(String s) {
        String[] parts;
        if (s == null) {
            return null;
        }
        Vector<Integer> ints = new Vector<Integer>();
        String[] stringArray = parts = s.split("[:, \t\r\n]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                ints.add(Integer.valueOf(part));
            }
            ++n2;
        }
        return ints;
    }

    public static List<Integer> getAsIntList(String propertyName) {
        return LocalProperties.stringToIntList(LocalProperties.get(propertyName));
    }

    public static List<Integer> getAsIntList(String propertyName, Integer[] defaultValue) {
        ArrayList<Integer> result = LocalProperties.getAsIntList(propertyName);
        return result != null ? result : new ArrayList<Integer>(Arrays.asList(defaultValue));
    }

    public static Integer getAsInt(String propertyName) {
        String s = LocalProperties.get(propertyName);
        return s != null ? Integer.valueOf(s) : null;
    }

    public static Integer getAsInt(String propertyName, Integer defaultValue) {
        String s = LocalProperties.get(propertyName);
        return s != null ? Integer.valueOf(s) : defaultValue;
    }

    public static boolean contains(String propertyName) {
        return propConfig.containsKey(propertyName);
    }

    public static void clearProperty(String key) {
        propConfig.clearProperty(key);
    }

    public static void checkForObsoleteProperties() {
        if (LocalProperties.get("gda.objectDelimiter") != null) {
            logger.warn("Please remove the " + StringUtils.quote((String)"gda.objectDelimiter") + " property from your java.properties file - it is not used any more");
        }
        if (LocalProperties.get("gda.eventreceiver.purge") != null) {
            logger.warn("Please remove the " + StringUtils.quote((String)"gda.eventreceiver.purge") + " property from your java.properties file - CorbaEventReceiver does not purge events any more");
        }
        if (LocalProperties.get("gda.users") != null) {
            logger.warn("Please remove the " + StringUtils.quote((String)"gda.users") + " property from your java.properties file - this property was used ambiguously and should not be used any more");
        }
        if (LocalProperties.get("gda.jython.gdaScriptDir") != null) {
            logger.warn("Please remove the " + StringUtils.quote((String)"gda.jython.gdaScriptDir") + "property from your java.properties file - script paths are defined in the Spring configuration for the command_server.");
        }
        if (LocalProperties.get("gda.jython.userScriptDir") != null) {
            logger.warn("Please remove the " + StringUtils.quote((String)"gda.jython.userScriptDir") + "property from your java.properties file - script paths are defined in the Spring configuration for the command_server.");
        }
    }
}

