/*
 * Decompiled with CFR 0.152.
 */
package gda.configuration.properties;

import gda.configuration.properties.LocalProperties;
import gda.configuration.properties.PropertiesConfig;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaPropertiesConfig
implements PropertiesConfig {
    private static final Logger logger = LoggerFactory.getLogger(JakartaPropertiesConfig.class);
    private CompositeConfiguration config = new CompositeConfiguration();
    private Map<String, Configuration> configMap = null;

    public JakartaPropertiesConfig() {
        SystemConfiguration sysConfig = new SystemConfiguration();
        this.config.addConfiguration((Configuration)sysConfig);
        this.configMap = new HashMap<String, Configuration>();
        this.configMap.put("system", (Configuration)sysConfig);
    }

    public void ResetProperties() {
        this.config.clear();
        SystemConfiguration sysConfig = new SystemConfiguration();
        this.config.addConfiguration((Configuration)sysConfig);
        this.configMap.clear();
        this.configMap.put("system", (Configuration)sysConfig);
    }

    private void configFactoryBasePathBugWorkaround(ConfigurationFactory factory, String listName) {
        int pathEndIndex = 0;
        pathEndIndex = Math.max(pathEndIndex, listName.lastIndexOf(92));
        pathEndIndex = Math.max(pathEndIndex, listName.lastIndexOf(47));
        String p = listName.substring(0, pathEndIndex);
        factory.setBasePath(p);
    }

    @Override
    public void loadPropertyData(String listName) throws ConfigurationException {
        XMLConfiguration userConfig = null;
        if (listName.contains(".xml")) {
            if (listName.endsWith("config.xml")) {
                ConfigurationFactory factory = new ConfigurationFactory();
                this.configFactoryBasePathBugWorkaround(factory, listName);
                factory.setConfigurationFileName(listName);
                userConfig = factory.getConfiguration();
            } else {
                userConfig = new XMLConfiguration(listName);
            }
        } else if (listName.contains(".properties")) {
            userConfig = new PropertiesConfiguration(listName);
        }
        if (userConfig != null) {
            this.config.addConfiguration((Configuration)userConfig);
            this.configMap.put(listName, (Configuration)userConfig);
        }
    }

    @Override
    public void dumpProperties() {
        Iterator keyIterator = this.config.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object o = this.config.getProperty(key);
            if (o == null) continue;
            if (o instanceof String) {
                logger.debug(String.valueOf(key) + " = " + LocalProperties.get(key));
                continue;
            }
            logger.debug(String.valueOf(key) + " = " + o.toString());
        }
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        return this.config.getInt(name, defaultValue);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.config.getString(name, defaultValue);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        return this.config.getFloat(name, defaultValue);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        return this.config.getDouble(name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.config.getBoolean(name, defaultValue);
    }

    @Override
    public String getPath(String name, String defaultValue) {
        String value = this.config.getString(name, defaultValue);
        if (value != null) {
            value = value.replace('\\', '/');
        }
        return value;
    }

    @Override
    public URL getURL(String name, URL defaultValue) {
        DataConfiguration dataConfig = new DataConfiguration((Configuration)this.config);
        return dataConfig.getURL(name, defaultValue);
    }

    @Override
    public void setString(String value, String name) {
        this.config.setProperty(name, (Object)value);
    }

    @Override
    public void clearProperty(String key) {
        this.config.clearProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }
}

