/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.utils;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;
import uk.ac.gda.monitor.IMonitor;

public class ImageThumbnailLoader {
    private static final Logger logger = LoggerFactory.getLogger(ImageThumbnailLoader.class);
    private static final int DOWNSAMPLE_SIZE_IN_PIXELS = 96;

    public static AbstractDataset loadImage(String string, boolean bl) {
        return ImageThumbnailLoader.loadImage(string, bl, null);
    }

    public static AbstractDataset loadImage(String string, boolean bl, IMonitor iMonitor) {
        DataHolder dataHolder = null;
        if (!string.toLowerCase().endsWith(".raw")) {
            try {
                dataHolder = LoaderFactory.getData(string, !bl, iMonitor);
            }
            catch (Exception exception) {
                logger.error("Cannot load " + string, (Throwable)exception);
            }
        } else {
            RawBinaryLoader rawBinaryLoader = new RawBinaryLoader(string);
            try {
                dataHolder = rawBinaryLoader.loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                logger.error("Cannot load " + string, (Throwable)scanFileHolderException);
            }
        }
        return ImageThumbnailLoader.getSingle(string, bl, dataHolder);
    }

    public static AbstractDataset getSingle(String string, boolean bl, DataHolder dataHolder) {
        AbstractDataset abstractDataset;
        if (dataHolder != null && dataHolder.size() > 0 && (abstractDataset = dataHolder.getDataset(0)).getRank() == 2) {
            int n = abstractDataset.getShape()[1];
            int n2 = abstractDataset.getShape()[0];
            String string2 = new File(string).getName();
            String string3 = abstractDataset.getName();
            if (string3 == null || string3.length() == 0 || string3.contains("image-")) {
                abstractDataset.setName(string2);
            } else {
                abstractDataset.setName(String.valueOf(string2) + ":" + abstractDataset.getName());
            }
            if (bl) {
                int n3 = Math.max(1, (n > n2 ? n : n2) / 96);
                int[] nArray = new int[]{n3, n3};
                Downsample downsample = new Downsample(DownsampleMode.POINT, nArray);
                AbstractDataset abstractDataset2 = downsample.value(abstractDataset).get(0);
                abstractDataset2.setName(new String(string));
                return abstractDataset2;
            }
            return abstractDataset;
        }
        abstractDataset = AbstractDataset.zeros(new int[]{96, 96}, 0);
        abstractDataset.setName("Invalid Image");
        return abstractDataset;
    }
}

