/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.MockDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcGenericStaticClassDispatcher;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.TypedNone;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.ManyArguments;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.NoArgument;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.NullPrimitive;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.SingleArgumentBoxedPrimitiveArrays;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.SingleArgumentBoxedPrimitives;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.SingleArgumentPrimitiveArrays;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.SingleArgumentPrimitives;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.SingleArgumentSDAPlotterDataTypes;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.UsedForVarious;
import uk.ac.diamond.scisoft.analysis.rpc.staticdispatchertypes.VoidReturn;

public class StaticClassDispatcherTest {
    @Test
    public void testPrimitiveTypes() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentPrimitives.class);
        Assert.assertEquals(Boolean.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", false}));
        Assert.assertEquals(Byte.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", (byte)0}));
        Assert.assertEquals(Character.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", Character.valueOf('\u0000')}));
        Assert.assertEquals(Double.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0.0}));
        Assert.assertEquals(Float.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", Float.valueOf(0.0f)}));
        Assert.assertEquals(Integer.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0}));
        Assert.assertEquals(Long.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0L}));
        Assert.assertEquals(Short.TYPE, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", (short)0}));
    }

    @Test
    public void testPrimitiveArrayTypes() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentPrimitiveArrays.class);
        Assert.assertEquals(boolean[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new boolean[1]}));
        Assert.assertEquals(byte[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new byte[1]}));
        Assert.assertEquals(char[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new char[1]}));
        Assert.assertEquals(double[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new double[]{0.0}}));
        Assert.assertEquals(float[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new float[]{0.0f}}));
        Assert.assertEquals(int[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new int[1]}));
        Assert.assertEquals(long[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new long[1]}));
        Assert.assertEquals(short[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new short[1]}));
    }

    @Test
    public void testBoxedPrimitiveTypes() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentBoxedPrimitives.class);
        Assert.assertEquals(Boolean.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", false}));
        Assert.assertEquals(Byte.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", (byte)0}));
        Assert.assertEquals(Character.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", Character.valueOf('\u0000')}));
        Assert.assertEquals(Double.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0.0}));
        Assert.assertEquals(Float.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", Float.valueOf(0.0f)}));
        Assert.assertEquals(Integer.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0}));
        Assert.assertEquals(Long.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0L}));
        Assert.assertEquals(Short.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", (short)0}));
    }

    @Test
    public void testBoxedPrimitiveArrayTypes() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentBoxedPrimitiveArrays.class);
        Assert.assertEquals(Boolean[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Boolean[]{false}}));
        Assert.assertEquals(Byte[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Byte[]{(byte)0}}));
        Assert.assertEquals(Character[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Character[]{Character.valueOf('\u0000')}}));
        Assert.assertEquals(Double[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Double[]{0.0}}));
        Assert.assertEquals(Float[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Float[]{Float.valueOf(0.0f)}}));
        Assert.assertEquals(Integer[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Integer[]{0}}));
        Assert.assertEquals(Long[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Long[]{0L}}));
        Assert.assertEquals(Short[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new Short[]{(short)0}}));
    }

    @Test
    public void testSDAPlotterTypes() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentSDAPlotterDataTypes.class);
        Assert.assertEquals(GuiBean.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new GuiBean()}));
        Assert.assertEquals(GuiPlotMode.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", GuiPlotMode.EMPTY}));
        Assert.assertEquals(IDataset.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new MockDataset()}));
        Assert.assertEquals(IDataset[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new IDataset[]{new MockDataset()}}));
        Assert.assertEquals(String[].class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", new String[]{"Hello"}}));
        Assert.assertEquals(String.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", "Hello"}));
    }

    @Test
    public void testNoArgs() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(NoArgument.class);
        Assert.assertEquals((Object)"no argument", (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call"}));
    }

    @Test
    public void testVoidReturn() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(VoidReturn.class);
        Assert.assertEquals(null, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 0}));
    }

    @Test
    public void testManyArguments() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(ManyArguments.class);
        Assert.assertEquals((Object)8, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6, 7, 8}));
        Assert.assertEquals((Object)7, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6, 7}));
        Assert.assertEquals((Object)6, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6}));
        Assert.assertEquals((Object)5, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5}));
        Assert.assertEquals((Object)4, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3, 4}));
        Assert.assertEquals((Object)3, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2, 3}));
        Assert.assertEquals((Object)2, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1, 2}));
        Assert.assertEquals((Object)1, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call", 1}));
        Assert.assertEquals((Object)0, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"call"}));
    }

    @Test
    public void testNoSuchMethod() {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        try {
            analysisRpcGenericStaticClassDispatcher.run(new Object[]{"missing", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOnlyMatchingMethodIsNonStatic() {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        try {
            analysisRpcGenericStaticClassDispatcher.run(new Object[]{"nonStaticMethod", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimilarSignatureStaticAndNonStatic() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        Assert.assertEquals((Object)"static", (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"similarSignatureStaticAndNonStatic", 0}));
    }

    @Test
    public void testCallCheckedException() {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        try {
            analysisRpcGenericStaticClassDispatcher.run(new Object[]{"callCheckedException", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((boolean)(analysisRpcException.getCause() instanceof IOException));
        }
    }

    @Test
    public void testCallUnCheckedException() {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        try {
            analysisRpcGenericStaticClassDispatcher.run(new Object[]{"callUnCheckedException", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((boolean)(analysisRpcException.getCause() instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testOverloadedAssignable() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        Assert.assertEquals(Integer.class, UsedForVarious.overloaded(0));
        Assert.assertEquals(Object.class, UsedForVarious.overloaded(new Object()));
        Assume.assumeTrue((boolean)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"overloaded", new Object()}).equals(analysisRpcGenericStaticClassDispatcher.run(new Object[]{"overloaded", 0})));
    }

    @Test
    public void testNullArgument() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        Object[] objectArray = new Object[2];
        objectArray[0] = "callObjectWithNull";
        Assert.assertEquals((Object)"callObjectWithNull", (Object)analysisRpcGenericStaticClassDispatcher.run(objectArray));
    }

    @Test
    public void testNullDoesntMatchPrimitives1() {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(SingleArgumentPrimitives.class);
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = "call";
            analysisRpcGenericStaticClassDispatcher.run(objectArray);
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNullDoesntMatchPrimitives2() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(NullPrimitive.class);
        Object[] objectArray = new Object[2];
        objectArray[0] = "call";
        Assert.assertEquals(Object.class, (Object)analysisRpcGenericStaticClassDispatcher.run(objectArray));
    }

    @Test
    public void testNullReturn() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        Assert.assertEquals(null, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"callNullReturn", 0}));
        Assert.assertEquals(null, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"callNullReturn", "arg"}));
    }

    @Test
    public void testTypedNullArgument() throws AnalysisRpcException {
        AnalysisRpcGenericStaticClassDispatcher analysisRpcGenericStaticClassDispatcher = new AnalysisRpcGenericStaticClassDispatcher(UsedForVarious.class);
        Assert.assertEquals(Integer.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"typednone", new TypedNone(Integer.class)}));
        Assert.assertEquals(String.class, (Object)analysisRpcGenericStaticClassDispatcher.run(new Object[]{"typednone", new TypedNone(String.class)}));
    }
}

