/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.sdaplotter;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import uk.ac.diamond.scisoft.analysis.AnalysisRpcServerProvider;
import uk.ac.diamond.scisoft.analysis.ISDAPlotter;
import uk.ac.diamond.scisoft.analysis.PlotService;
import uk.ac.diamond.scisoft.analysis.PythonHelper;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.SDAPlotterImpl;
import uk.ac.diamond.scisoft.analysis.SDAPlotterTestAbstract;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcGenericInstanceDispatcher;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;
import uk.ac.diamond.scisoft.analysis.rpc.sdaplotter.ReDirectOverRpcPlotterImpl;

public class SDAPlotterViaRpcTest
extends SDAPlotterTestAbstract {
    private static PythonHelper.PythonRunInfo pythonRunInfo;
    private static IAnalysisRpcHandler savedHandler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        SDAPlotterImpl sDAPlotterImpl = new SDAPlotterImpl(){

            @Override
            protected PlotService getPlotService() {
                return testPlotServer;
            }
        };
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = new AnalysisRpcGenericInstanceDispatcher(ISDAPlotter.class, sDAPlotterImpl);
        savedHandler = AnalysisRpcServerProvider.getInstance().getHandler(SDAPlotter.class.getSimpleName());
        AnalysisRpcServerProvider.getInstance().addHandler(SDAPlotter.class.getSimpleName(), analysisRpcGenericInstanceDispatcher);
        AnalysisRpcServerProvider.getInstance().startServer();
        String[] stringArray = new String[]{"SCISOFT_RPC_PORT=" + AnalysisRpcServerProvider.getInstance().getPort()};
        pythonRunInfo = PythonHelper.runPythonFileBackground("../uk.ac.diamond.scisoft.python/test/scisoftpy/loopback.py", new String[]{"../uk.ac.diamond.scisoft.python/src/"}, stringArray);
        sdaPlotterImplUnderTest = new ReDirectOverRpcPlotterImpl();
    }

    private void checkPythonState() {
        if (pythonRunInfo != null && pythonRunInfo.hasTerminated()) {
            pythonRunInfo.getStdout(true);
            throw new RuntimeException("Python script unexpectedly terminated");
        }
    }

    @Before
    public void checkBefore() {
        this.checkPythonState();
    }

    @After
    public void checkAfter() {
        this.checkPythonState();
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (pythonRunInfo != null) {
            pythonRunInfo.terminate();
            pythonRunInfo.getStdout(true);
        }
        pythonRunInfo = null;
        try {
            AnalysisRpcServerProvider.getInstance().addHandler(SDAPlotter.class.getSimpleName(), savedHandler);
        }
        catch (AnalysisRpcException analysisRpcException) {
            throw new RuntimeException("Failed to restore handler", analysisRpcException);
        }
    }
}

