/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.MockDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcGenericInstanceDispatcher;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.TypedNone;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.InterfaceAndImpl;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.ManyArguments;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.NoArgument;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.NullPrimitive;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.SingleArgumentBoxedPrimitiveArrays;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.SingleArgumentBoxedPrimitives;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.SingleArgumentPrimitiveArrays;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.SingleArgumentPrimitives;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.SingleArgumentSDAPlotterDataTypes;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.UsedForVarious;
import uk.ac.diamond.scisoft.analysis.rpc.instancedispatcher.VoidReturn;

public class InstanceDispatcherTest {
    @Test
    public void testPrimitiveTypes() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentPrimitives());
        Assert.assertEquals(Boolean.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", false}));
        Assert.assertEquals(Byte.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", (byte)0}));
        Assert.assertEquals(Character.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", Character.valueOf('\u0000')}));
        Assert.assertEquals(Double.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0.0}));
        Assert.assertEquals(Float.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", Float.valueOf(0.0f)}));
        Assert.assertEquals(Integer.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0}));
        Assert.assertEquals(Long.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0L}));
        Assert.assertEquals(Short.TYPE, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", (short)0}));
    }

    @Test
    public void testPrimitiveArrayTypes() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentPrimitiveArrays());
        Assert.assertEquals(boolean[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new boolean[1]}));
        Assert.assertEquals(byte[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new byte[1]}));
        Assert.assertEquals(char[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new char[1]}));
        Assert.assertEquals(double[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new double[]{0.0}}));
        Assert.assertEquals(float[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new float[]{0.0f}}));
        Assert.assertEquals(int[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new int[1]}));
        Assert.assertEquals(long[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new long[1]}));
        Assert.assertEquals(short[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new short[1]}));
    }

    @Test
    public void testBoxedPrimitiveTypes() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentBoxedPrimitives());
        Assert.assertEquals(Boolean.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", false}));
        Assert.assertEquals(Byte.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", (byte)0}));
        Assert.assertEquals(Character.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", Character.valueOf('\u0000')}));
        Assert.assertEquals(Double.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0.0}));
        Assert.assertEquals(Float.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", Float.valueOf(0.0f)}));
        Assert.assertEquals(Integer.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0}));
        Assert.assertEquals(Long.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0L}));
        Assert.assertEquals(Short.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", (short)0}));
    }

    @Test
    public void testBoxedPrimitiveArrayTypes() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentBoxedPrimitiveArrays());
        Assert.assertEquals(Boolean[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Boolean[]{false}}));
        Assert.assertEquals(Byte[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Byte[]{(byte)0}}));
        Assert.assertEquals(Character[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Character[]{Character.valueOf('\u0000')}}));
        Assert.assertEquals(Double[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Double[]{0.0}}));
        Assert.assertEquals(Float[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Float[]{Float.valueOf(0.0f)}}));
        Assert.assertEquals(Integer[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Integer[]{0}}));
        Assert.assertEquals(Long[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Long[]{0L}}));
        Assert.assertEquals(Short[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new Short[]{(short)0}}));
    }

    @Test
    public void testSDAPlotterTypes() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentSDAPlotterDataTypes());
        Assert.assertEquals(GuiBean.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new GuiBean()}));
        Assert.assertEquals(GuiPlotMode.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", GuiPlotMode.EMPTY}));
        Assert.assertEquals(IDataset.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new MockDataset()}));
        Assert.assertEquals(IDataset[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new IDataset[]{new MockDataset()}}));
        Assert.assertEquals(String[].class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", new String[]{"Hello"}}));
        Assert.assertEquals(String.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", "Hello"}));
    }

    @Test
    public void testNoArgs() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new NoArgument());
        Assert.assertEquals((Object)"no argument", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call"}));
    }

    @Test
    public void testVoidReturn() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new VoidReturn());
        Assert.assertEquals(null, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 0}));
    }

    @Test
    public void testManyArguments() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new ManyArguments());
        Assert.assertEquals((Object)8, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6, 7, 8}));
        Assert.assertEquals((Object)7, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6, 7}));
        Assert.assertEquals((Object)6, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5, 6}));
        Assert.assertEquals((Object)5, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3, 4, 5}));
        Assert.assertEquals((Object)4, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3, 4}));
        Assert.assertEquals((Object)3, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2, 3}));
        Assert.assertEquals((Object)2, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1, 2}));
        Assert.assertEquals((Object)1, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call", 1}));
        Assert.assertEquals((Object)0, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"call"}));
    }

    @Test
    public void testNoSuchMethod() {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"missing", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOnlyMatchingMethodIsNonStatic() {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"nonStaticMethod", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimilarSignatureStaticAndNonStatic() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Assert.assertEquals((Object)"non-static", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"similarSignatureStaticAndNonStatic", 0}));
    }

    @Test
    public void testCallCheckedException() {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"callCheckedException", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((boolean)(analysisRpcException.getCause() instanceof IOException));
        }
    }

    @Test
    public void testCallUnCheckedException() {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"callUnCheckedException", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((boolean)(analysisRpcException.getCause() instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testOverloadedAssignable() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Assert.assertFalse((boolean)new UsedForVarious().overloaded(new Object()).equals(new UsedForVarious().overloaded(0)));
        Assume.assumeTrue((boolean)analysisRpcGenericInstanceDispatcher.run(new Object[]{"overloaded", new Object()}).equals(analysisRpcGenericInstanceDispatcher.run(new Object[]{"overloaded", 0})));
    }

    @Test
    public void testNullArgument() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Object[] objectArray = new Object[2];
        objectArray[0] = "callObjectWithNull";
        Assert.assertEquals((Object)"callObjectWithNull", (Object)analysisRpcGenericInstanceDispatcher.run(objectArray));
    }

    @Test
    public void testNullDoesntMatchPrimitives1() {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new SingleArgumentPrimitives());
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = "call";
            analysisRpcGenericInstanceDispatcher.run(objectArray);
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNullDoesntMatchPrimitives2() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new NullPrimitive());
        Object[] objectArray = new Object[2];
        objectArray[0] = "call";
        Assert.assertEquals(Object.class, (Object)analysisRpcGenericInstanceDispatcher.run(objectArray));
    }

    @Test
    public void testNullReturn() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Assert.assertEquals(null, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"callNullReturn", 0}));
        Assert.assertEquals(null, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"callNullReturn", "arg"}));
    }

    @Test
    public void testMisMatched() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Assert.assertEquals(null, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"callNullReturn", 0}));
        Assert.assertEquals(null, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"callNullReturn", "arg"}));
    }

    @Test
    public void testInterfaceAndImpl_InterfaceDelegate() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = new AnalysisRpcGenericInstanceDispatcher(InterfaceAndImpl.class, new InterfaceAndImpl.Impl());
        Assert.assertEquals((Object)"interfacecall", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"interfacecall", 0}));
        Assert.assertEquals((Object)"implcalloverloaded - interface", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcalloverloaded", 0}));
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcalloverloaded", "string"});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
        try {
            analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcall", 0});
            Assert.fail();
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertTrue((analysisRpcException.getMessage().indexOf("Failed to find method") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInterfaceAndImpl_ImplDelegate() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new InterfaceAndImpl.Impl());
        Assert.assertEquals((Object)"interfacecall", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"interfacecall", 0}));
        Assert.assertEquals((Object)"implcalloverloaded - interface", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcalloverloaded", 0}));
        Assert.assertEquals((Object)"implcalloverloaded - impl", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcalloverloaded", "string"}));
        Assert.assertEquals((Object)"implcall", (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"implcall", 0}));
    }

    @Test(expected=NullPointerException.class)
    public void testExceptionOnCreation1() {
        new AnalysisRpcGenericInstanceDispatcher(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testExceptionOnCreation2() {
        new AnalysisRpcGenericInstanceDispatcher(Object.class, null);
    }

    @Test(expected=NullPointerException.class)
    public void testExceptionOnCreation3() {
        new AnalysisRpcGenericInstanceDispatcher(null, new Object());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionOnCreation4() {
        new AnalysisRpcGenericInstanceDispatcher(Integer.class, new Object());
    }

    @Test
    public void testTypedNullArgument() throws AnalysisRpcException {
        AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = AnalysisRpcGenericInstanceDispatcher.getDispatcher(new UsedForVarious());
        Assert.assertEquals(Integer.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"typednone", new TypedNone(Integer.class)}));
        Assert.assertEquals(String.class, (Object)analysisRpcGenericInstanceDispatcher.run(new Object[]{"typednone", new TypedNone(String.class)}));
    }
}

