/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.util.Map;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers.ROIHelper;

public class SectorROIHelper
extends ROIHelper<SectorROI> {
    public static final String ANG = "ang";
    public static final String RAD = "rad";
    public static final String CLIPPING_COMPENSATION = "clippingCompensation";
    public static final String SYMMETRY = "symmetry";
    public static final String COMBINE_SYMMETRY = "combineSymmetry";
    public static final String AVERAGE_AREA = "averageArea";

    public SectorROIHelper() {
        super(SectorROI.class);
    }

    @Override
    public Map<String, Object> flatten(Object object, IRootFlattener iRootFlattener) {
        SectorROI sectorROI = (SectorROI)object;
        Map<String, Object> map = super.flatten(sectorROI, SectorROI.class.getCanonicalName(), iRootFlattener);
        map.put(ANG, iRootFlattener.flatten(sectorROI.getAngles()));
        Object object2 = iRootFlattener.flatten(sectorROI.getRadii());
        map.put(RAD, object2);
        map.put(CLIPPING_COMPENSATION, iRootFlattener.flatten(sectorROI.isClippingCompensation()));
        map.put(SYMMETRY, iRootFlattener.flatten(sectorROI.getSymmetry()));
        map.put(COMBINE_SYMMETRY, iRootFlattener.flatten(sectorROI.isCombineSymmetry()));
        map.put(AVERAGE_AREA, iRootFlattener.flatten(sectorROI.isAverageArea()));
        return map;
    }

    @Override
    public SectorROI unflatten(Map<?, ?> map, IRootFlattener iRootFlattener) {
        SectorROI sectorROI = new SectorROI();
        sectorROI.setPoint((double[])iRootFlattener.unflatten(map.get("spt")));
        sectorROI.setPlot((Boolean)iRootFlattener.unflatten(map.get("plot")));
        sectorROI.setAngles((double[])iRootFlattener.unflatten(map.get(ANG)));
        double[] dArray = (double[])iRootFlattener.unflatten(map.get(RAD));
        sectorROI.setRadii(dArray);
        sectorROI.setClippingCompensation((Boolean)iRootFlattener.unflatten(map.get(CLIPPING_COMPENSATION)));
        sectorROI.setSymmetry((Integer)iRootFlattener.unflatten(map.get(SYMMETRY)));
        sectorROI.setCombineSymmetry((Boolean)iRootFlattener.unflatten(map.get(COMBINE_SYMMETRY)));
        sectorROI.setAverageArea((Boolean)iRootFlattener.unflatten(map.get(AVERAGE_AREA)));
        return sectorROI;
    }
}

