/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.util.Map;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers.ROIHelper;

public class RectangularROIHelper
extends ROIHelper<RectangularROI> {
    public static final String LEN = "len";
    public static final String ANG = "ang";
    public static final String CLIPPING_COMPENSATION = "clippingCompensation";

    public RectangularROIHelper() {
        super(RectangularROI.class);
    }

    @Override
    public Map<String, Object> flatten(Object object, IRootFlattener iRootFlattener) {
        RectangularROI rectangularROI = (RectangularROI)object;
        Map<String, Object> map = super.flatten(rectangularROI, RectangularROI.class.getCanonicalName(), iRootFlattener);
        map.put(LEN, iRootFlattener.flatten(rectangularROI.getLengths()));
        map.put(ANG, iRootFlattener.flatten(rectangularROI.getAngle()));
        map.put(CLIPPING_COMPENSATION, iRootFlattener.flatten(rectangularROI.isClippingCompensation()));
        return map;
    }

    @Override
    public RectangularROI unflatten(Map<?, ?> map, IRootFlattener iRootFlattener) {
        RectangularROI rectangularROI = new RectangularROI();
        rectangularROI.setPoint((double[])iRootFlattener.unflatten(map.get("spt")));
        rectangularROI.setPlot((Boolean)iRootFlattener.unflatten(map.get("plot")));
        rectangularROI.setLengths((double[])iRootFlattener.unflatten(map.get(LEN)));
        rectangularROI.setAngle((Double)iRootFlattener.unflatten(map.get(ANG)));
        rectangularROI.setClippingCompensation((Boolean)iRootFlattener.unflatten(map.get(CLIPPING_COMPENSATION)));
        return rectangularROI;
    }
}

