/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.util.HashMap;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.TypedNone;

public class NoneFlatteningHelper
implements IFlattener<Object> {
    static final String TYPE_NAME = "__None__";
    static final String TYPED_NONE_TYPE = "typedNoneType";
    static final String NULL = "null";

    @Override
    public Object flatten(Object object, IRootFlattener iRootFlattener) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__type__", TYPE_NAME);
        if (object == null) {
            hashMap.put(TYPED_NONE_TYPE, NULL);
        } else {
            TypedNone typedNone = (TypedNone)object;
            hashMap.put(TYPED_NONE_TYPE, typedNone.getType().getCanonicalName());
        }
        return hashMap;
    }

    @Override
    public Object unflatten(Object object, IRootFlattener iRootFlattener) {
        if (object == null) {
            return null;
        }
        String string = (String)((Map)object).get(TYPED_NONE_TYPE);
        if (string != null && !string.equals(NULL)) {
            try {
                TypedNone typedNone = new TypedNone(string);
                return typedNone;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    @Override
    public boolean canFlatten(Object object) {
        return object == null || object instanceof TypedNone;
    }

    @Override
    public boolean canUnFlatten(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return TYPE_NAME.equals(map.get("__type__"));
        }
        return false;
    }
}

