/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.util.Map;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers.ROIHelper;

public class LinearROIHelper
extends ROIHelper<LinearROI> {
    public static final String LEN = "len";
    public static final String ANG = "ang";
    public static final String CROSS_HAIR = "crossHair";

    public LinearROIHelper() {
        super(LinearROI.class);
    }

    @Override
    public Map<String, Object> flatten(Object object, IRootFlattener iRootFlattener) {
        LinearROI linearROI = (LinearROI)object;
        Map<String, Object> map = super.flatten(linearROI, LinearROI.class.getCanonicalName(), iRootFlattener);
        map.put(LEN, iRootFlattener.flatten(linearROI.getLength()));
        map.put(ANG, iRootFlattener.flatten(linearROI.getAngle()));
        map.put(CROSS_HAIR, iRootFlattener.flatten(linearROI.isCrossHair()));
        return map;
    }

    @Override
    public LinearROI unflatten(Map<?, ?> map, IRootFlattener iRootFlattener) {
        double[] dArray = (double[])iRootFlattener.unflatten(map.get("spt"));
        Boolean bl = (Boolean)iRootFlattener.unflatten(map.get("plot"));
        Double d = (Double)iRootFlattener.unflatten(map.get(LEN));
        Double d2 = (Double)iRootFlattener.unflatten(map.get(ANG));
        Boolean bl2 = (Boolean)iRootFlattener.unflatten(map.get(CROSS_HAIR));
        LinearROI linearROI = new LinearROI(d, d2);
        linearROI.setPoint(dArray);
        linearROI.setPlot(bl);
        linearROI.setCrossHair(bl2);
        return linearROI;
    }
}

