/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers.MapFlatteningHelper;

public class GuiBeanHelper
extends MapFlatteningHelper<GuiBean> {
    static Set<GuiParameters> unsupported;

    public GuiBeanHelper() {
        super(GuiBean.class);
        unsupported = new HashSet<GuiParameters>();
        unsupported.add(GuiParameters.FILEOPERATION);
        unsupported.add(GuiParameters.GRIDPREFERENCES);
        unsupported.add(GuiParameters.MASKING);
        unsupported.add(GuiParameters.CALIBRATIONFUNCTIONNCD);
        unsupported.add(GuiParameters.CALIBRATIONPEAKS);
    }

    @Override
    public Object flatten(Object object, IRootFlattener iRootFlattener) {
        GuiBean guiBean = (GuiBean)object;
        Map<String, Object> map = this.getFlattenedOutMap(GuiBean.class);
        map.put("__type__", GuiBean.class.getCanonicalName());
        Set set = guiBean.entrySet();
        for (Map.Entry entry : set) {
            GuiParameters guiParameters = (GuiParameters)entry.getKey();
            String string = guiParameters.toString();
            if (unsupported.contains(guiParameters)) continue;
            Object object2 = iRootFlattener.flatten(entry.getValue());
            map.put(string, object2);
        }
        return map;
    }

    @Override
    public GuiBean unflatten(Map<?, ?> map, IRootFlattener iRootFlattener) {
        GuiBean guiBean = new GuiBean();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            GuiParameters guiParameters;
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> entry2 = entry = iterator.next();
            String string = (String)entry2.getKey();
            Serializable serializable = (Serializable)iRootFlattener.unflatten(entry2.getValue());
            if (string.equals("__type__") || !(guiParameters = GuiParameters.valueOf(string)).toString().equals(string)) continue;
            guiBean.put(guiParameters, this.unflattenParam(guiParameters, serializable));
        }
        return guiBean;
    }

    private Serializable unflattenParam(GuiParameters guiParameters, Serializable serializable) {
        Class<?> clazz = guiParameters.getStorageClass();
        if (clazz.isInstance(serializable)) {
            return serializable;
        }
        if (clazz.equals(List.class)) {
            return new ArrayList<Object>(Arrays.asList((Object[])serializable));
        }
        if (clazz.equals(Integer[].class)) {
            return ArrayUtils.toObject((int[])((int[])serializable));
        }
        if (clazz.equals(GuiPlotMode.class)) {
            return GuiPlotMode.valueOf((String)((Object)serializable));
        }
        if (clazz.equals(UUID.class)) {
            return UUID.fromString(serializable.toString());
        }
        return serializable;
    }
}

