/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileSaver;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.helpers.MapFlatteningHelper;

public class AbstractDatasetHelper
extends MapFlatteningHelper<AbstractDataset> {
    public static final String TYPE_NAME = AbstractDataset.class.getCanonicalName();
    public static final String FILENAME = "filename";
    public static final String DELETEFILEAFTERLOAD = "deletefile";
    public static final String INDEX = "index";
    public static final String NAME = "name";

    public AbstractDatasetHelper() {
        super(AbstractDataset.class);
    }

    @Override
    public AbstractDataset unflatten(Map<?, ?> map, IRootFlattener iRootFlattener) {
        String string = (String)iRootFlattener.unflatten(map.get(FILENAME));
        Boolean bl = (Boolean)iRootFlattener.unflatten(map.get(DELETEFILEAFTERLOAD));
        Integer n = (Integer)iRootFlattener.unflatten(map.get(INDEX));
        String string2 = (String)iRootFlattener.unflatten(map.get(NAME));
        try {
            Serializable serializable;
            boolean bl2;
            DataHolder dataHolder = LoaderFactory.getData(string, false, null);
            if (bl != null && bl.booleanValue() && !(bl2 = ((File)(serializable = new File(string))).delete())) {
                ((File)serializable).deleteOnExit();
            }
            serializable = string2 != null ? dataHolder.getDataset(string2) : (n != null ? dataHolder.getDataset(n) : dataHolder.getDataset(0));
            return serializable;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Failed to load AbstractDataset from " + map, exception);
        }
    }

    @Override
    public boolean canFlatten(Object object) {
        return object instanceof AbstractDataset;
    }

    @Override
    public Object flatten(Object object, IRootFlattener iRootFlattener) {
        File file;
        DataHolder dataHolder = new DataHolder();
        AbstractDataset abstractDataset = (AbstractDataset)object;
        dataHolder.addDataset("", abstractDataset);
        try {
            file = File.createTempFile("scisofttmp-", ".npy", iRootFlattener.getTempLocation());
            new NumPyFileSaver(file.toString()).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unable to save AbstractDataset", exception);
        }
        Map<String, Object> map = this.createMap(TYPE_NAME);
        map.put(FILENAME, file.toString());
        map.put(DELETEFILEAFTERLOAD, true);
        map.put(INDEX, 0);
        return map;
    }

    @Override
    public boolean canUnFlatten(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return TYPE_NAME.equals(map.get("__type__"));
        }
        return false;
    }
}

