/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;

public class TempLocationTest {
    @Test
    public void testTempLocation() throws IOException {
        RootFlattener rootFlattener = new RootFlattener();
        File file = new File(System.getProperty("java.io.tmpdir"));
        Assert.assertEquals((Object)file, (Object)this.flattenDataSetAndReturnContainingFolder(rootFlattener));
        File file2 = this.createTempDirectory();
        Assert.assertFalse((boolean)file2.getCanonicalFile().equals(file.getCanonicalFile()));
        rootFlattener.setTempLocation(file2.toString());
        Assert.assertEquals((Object)file2, (Object)this.flattenDataSetAndReturnContainingFolder(rootFlattener));
        if (!file2.delete()) {
            throw new IOException("Failed to delete temporary dir");
        }
        rootFlattener.setTempLocation(null);
        Assert.assertEquals((Object)file, (Object)this.flattenDataSetAndReturnContainingFolder(rootFlattener));
    }

    private File flattenDataSetAndReturnContainingFolder(IRootFlattener iRootFlattener) throws IOException {
        Object object = iRootFlattener.flatten(AbstractDataset.arange(100.0, 3));
        Map map = (Map)object;
        File file = new File((String)map.get("filename"));
        Assert.assertTrue((boolean)file.exists());
        if (!file.delete()) {
            throw new IOException("Failed to delete temporary file");
        }
        File file2 = file.getParentFile();
        return file2;
    }

    private File createTempDirectory() throws IOException {
        File file = File.createTempFile("flattening-test-", null);
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        return file;
    }
}

