/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.io.IOException;
import java.net.URL;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.ExplicitFlatteningTestAbstract;

public class FlatteningViaXmlRpcTest
extends ExplicitFlatteningTestAbstract {
    static WebServer webServer;
    private static XmlRpcClient client;

    @BeforeClass
    public static void start() throws IOException, XmlRpcException {
        webServer = new WebServer(8614);
        XmlRpcStreamServer xmlRpcStreamServer = webServer.getXmlRpcServer();
        PropertyHandlerMapping propertyHandlerMapping = new PropertyHandlerMapping();
        propertyHandlerMapping.addHandler("Loopback", LoopbackClass.class);
        xmlRpcStreamServer.setHandlerMapping((XmlRpcHandlerMapping)propertyHandlerMapping);
        XmlRpcServerConfigImpl xmlRpcServerConfigImpl = (XmlRpcServerConfigImpl)xmlRpcStreamServer.getConfig();
        xmlRpcServerConfigImpl.setEnabledForExtensions(false);
        xmlRpcServerConfigImpl.setContentLengthOptional(false);
        webServer.start();
        XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
        xmlRpcClientConfigImpl.setServerURL(new URL("http://127.0.0.1:8614/xmlrpc"));
        client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
    }

    @AfterClass
    public static void stop() {
        if (webServer != null) {
            webServer.shutdown();
        }
        webServer = null;
        client = null;
    }

    @Override
    protected Object doAdditionalWorkOnFlattendForm(Object object) {
        try {
            return client.execute("Loopback.loopback", new Object[]{new Object[]{object}});
        }
        catch (XmlRpcException xmlRpcException) {
            throw new RuntimeException(xmlRpcException);
        }
    }

    public static class LoopbackClass {
        public Object loopback(Object[] objectArray) {
            return objectArray[0];
        }
    }
}

