/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcClient;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcServer;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.FlatteningTestAbstract;

public class FlatteningViaAnalysisRpcTest
extends FlatteningTestAbstract {
    private static AnalysisRpcServer server;
    private static AnalysisRpcClient client;

    @BeforeClass
    public static void start() throws AnalysisRpcException {
        server = new AnalysisRpcServer(8620);
        server.addHandler("loopback", new IAnalysisRpcHandler(){

            @Override
            public Object run(Object[] objectArray) {
                return objectArray[0];
            }
        });
        server.start();
        client = new AnalysisRpcClient(8620);
    }

    @AfterClass
    public static void stop() {
        if (server != null) {
            server.shutdown();
        }
        server = null;
        client = null;
    }

    @Override
    protected Object doActualFlattenAndUnflatten(Object object) {
        try {
            return client.request("loopback", new Object[]{object});
        }
        catch (AnalysisRpcException analysisRpcException) {
            if (analysisRpcException.getCause().getClass() == Exception.class) {
                return analysisRpcException.getCause();
            }
            throw new RuntimeException(analysisRpcException);
        }
    }
}

