/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileSaver;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.roi.GridPreferences;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.LinearROIList;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROIList;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;
import uk.ac.diamond.scisoft.analysis.roi.SectorROIList;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.AbstractDatasetDescriptor;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.TypedNone;

public abstract class FlatteningTestAbstract {
    protected static IRootFlattener flattener;

    @BeforeClass
    public static void setUp() {
        flattener = new RootFlattener();
    }

    protected void assertFlattenEquals(Object object, Object object2) {
        if (object == null) {
            Assert.assertNull((Object)object2);
        } else if (object instanceof ROIBase || object instanceof AxisMapBean) {
            Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)object, (Object)object2));
        } else if (object instanceof DataBean) {
            DataBean dataBean = (DataBean)object;
            DataBean dataBean2 = (DataBean)object2;
            this.assertFlattenEquals(dataBean.getData(), dataBean2.getData());
            this.assertFlattenEquals(dataBean.getAxisData(), dataBean2.getAxisData());
        } else if (object instanceof DataSetWithAxisInformation) {
            DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)object;
            DataSetWithAxisInformation dataSetWithAxisInformation2 = (DataSetWithAxisInformation)object2;
            this.assertFlattenEquals(dataSetWithAxisInformation.getData(), dataSetWithAxisInformation2.getData());
            this.assertFlattenEquals(dataSetWithAxisInformation.getAxisMap(), dataSetWithAxisInformation2.getAxisMap());
        } else if (object instanceof Exception) {
            Exception exception = (Exception)object;
            Exception exception2 = (Exception)object2;
            Assert.assertEquals((Object)exception.getMessage(), (Object)exception2.getMessage());
        } else if (object instanceof List) {
            List list = (List)object;
            List list2 = (List)object2;
            Assert.assertEquals((long)list.size(), (long)list2.size());
            int n = 0;
            while (n < list2.size()) {
                this.assertFlattenEquals(list.get(n), list2.get(n));
                ++n;
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            Assert.assertArrayEquals((byte[])byArray, (byte[])byArray2);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            int[] nArray2 = (int[])object2;
            Assert.assertArrayEquals((int[])nArray, (int[])nArray2);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            Assert.assertArrayEquals((double[])dArray, (double[])dArray2, (double)0.0);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            boolean[] blArray2 = (boolean[])object2;
            Assert.assertTrue((boolean)Arrays.equals(blArray, blArray2));
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            Assert.assertEquals((long)objectArray.length, (long)objectArray2.length);
            int n = 0;
            while (n < objectArray2.length) {
                this.assertFlattenEquals(objectArray[n], objectArray2[n]);
                ++n;
            }
        } else if (object instanceof GuiBean) {
            GuiBean guiBean = (GuiBean)object;
            GuiBean guiBean2 = (GuiBean)object2;
            Assert.assertTrue((guiBean.size() >= guiBean2.size() ? 1 : 0) != 0);
            Set set = guiBean.entrySet();
            for (Map.Entry entry : set) {
                if (((GuiParameters)entry.getKey()).equals(GuiParameters.GRIDPREFERENCES) || ((GuiParameters)entry.getKey()).equals(GuiParameters.FILEOPERATION) || ((GuiParameters)entry.getKey()).getStorageClass().equals(Serializable.class)) {
                    Assert.assertFalse((boolean)guiBean2.containsKey(entry.getKey()));
                    continue;
                }
                Assert.assertTrue((boolean)guiBean2.containsKey(entry.getKey()));
                this.assertFlattenEquals(entry.getValue(), guiBean2.get(entry.getKey()));
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            Map map2 = (Map)object2;
            Assert.assertEquals((long)map.size(), (long)map2.size());
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Assert.assertTrue((boolean)map2.containsKey(entry2.getKey()));
                this.assertFlattenEquals(entry2.getValue(), map2.get(entry2.getKey()));
            }
        } else {
            Assert.assertEquals((Object)object, (Object)object2);
        }
    }

    protected Object flattenAndUnflatten(Object object) {
        return this.flattenAndUnflatten(object, object);
    }

    private Object flattenAndUnflatten(Object object, Object object2) {
        return this.flattenAndUnflatten(object, object2, object2.getClass());
    }

    protected abstract Object doActualFlattenAndUnflatten(Object var1);

    private Object flattenAndUnflatten(Object object, Object object2, Class<?> clazz) {
        Object object3 = this.doActualFlattenAndUnflatten(object);
        this.assertFlattenEquals(object2, object3);
        if (object2 != null && object2.getClass().equals(clazz)) {
            Assert.assertEquals(clazz, object3.getClass());
        } else if (clazz != null) {
            Assert.assertTrue((boolean)clazz.isAssignableFrom(object3.getClass()));
        }
        this.assertFlattenEquals(object3, this.doActualFlattenAndUnflatten(object3));
        return object3;
    }

    @Test
    public void testInteger() {
        this.flattenAndUnflatten(18);
        this.flattenAndUnflatten(-7);
        this.flattenAndUnflatten(0);
        this.flattenAndUnflatten(Integer.MIN_VALUE);
        this.flattenAndUnflatten(Integer.MAX_VALUE);
    }

    @Test
    public void testBoolean() {
        this.flattenAndUnflatten(true);
        this.flattenAndUnflatten(false);
    }

    @Test
    public void testString() {
        this.flattenAndUnflatten("");
        this.flattenAndUnflatten("bananas");
        this.flattenAndUnflatten("\nhello\tgoodbye");
    }

    @Test
    public void testDouble() {
        this.flattenAndUnflatten(0);
        this.flattenAndUnflatten(Math.PI);
        this.flattenAndUnflatten(Double.MIN_VALUE);
        this.flattenAndUnflatten(Double.MAX_VALUE);
    }

    @Test
    public void testDoubleSpecialValues() {
        this.flattenAndUnflatten(Double.NaN);
        this.flattenAndUnflatten(Double.NEGATIVE_INFINITY);
        this.flattenAndUnflatten(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testByeArray() {
        this.flattenAndUnflatten(new byte[]{1, 5, -7});
        this.flattenAndUnflatten(new byte[0]);
        this.flattenAndUnflatten(new byte[1000]);
    }

    @Test
    public void testMap() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        hashMap.put("pi", Math.PI);
        hashMap.put("One", new Double(1.0));
        this.flattenAndUnflatten(hashMap, hashMap, Map.class);
        TreeMap treeMap = new TreeMap(hashMap);
        this.flattenAndUnflatten(treeMap, treeMap, Map.class);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>(hashMap);
        hashMap2.put("Integer", 0);
        hashMap2.put("Integer", 100);
        this.flattenAndUnflatten(hashMap2, hashMap2, Map.class);
        HashMap<Serializable, Object> hashMap3 = new HashMap<Serializable, Object>(hashMap2);
        hashMap3.put(Integer.valueOf(0), 0);
        hashMap3.put(GuiParameters.FILENAME, "Filename");
        this.flattenAndUnflatten(hashMap3, hashMap3, Map.class);
    }

    @Test
    public void testObjectArrays() {
        this.flattenAndUnflatten(new Object[]{new Double(1.2), new Integer(2)});
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.flattenAndUnflatten(new Object[]{0, 1, 2, 3}, nArray);
        int[][] nArrayArray = new int[4][];
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArrayArray[0] = nArray2;
        nArrayArray[1] = new int[]{4, 5, 6, 7};
        nArrayArray[2] = new int[]{8, 9, 10, 11};
        nArrayArray[3] = new int[]{12, 13, 14, 15};
        this.flattenAndUnflatten(new Object[]{new Object[]{0, 1, 2, 3}, new Object[]{4, 5, 6, 7}, new Object[]{8, 9, 10, 11}, new Object[]{12, 13, 14, 15}}, nArrayArray);
        int[][] nArrayArray2 = new int[2][];
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray2[0] = nArray3;
        nArrayArray2[1] = new int[]{2, 3};
        this.flattenAndUnflatten(new Object[][]{{0, 1}, {2, 3}}, nArrayArray2);
        this.flattenAndUnflatten(new Object[0], new Object[0]);
        this.flattenAndUnflatten(new int[0], new Object[0]);
        this.flattenAndUnflatten(new String[0], new Object[0]);
        this.flattenAndUnflatten(new String[]{"one", "two"}, new String[]{"one", "two"});
        this.flattenAndUnflatten(new Object[]{"one", "two"}, new String[]{"one", "two"});
        this.flattenAndUnflatten(new Object[]{new RectangularROI(), new RectangularROI()}, new RectangularROI[]{new RectangularROI(), new RectangularROI()});
        this.flattenAndUnflatten(new Object[]{new RectangularROI(), new LinearROI()}, new ROIBase[]{new RectangularROI(), new LinearROI()});
        this.flattenAndUnflatten(new Object[]{new Integer(0), new RectangularROI(), new LinearROI()}, new Object[]{new Integer(0), new RectangularROI(), new LinearROI()});
        this.flattenAndUnflatten(new Object[]{new RectangularROI(), new LinearROI(), new Integer(0)}, new Object[]{new RectangularROI(), new LinearROI(), new Integer(0)});
        String[] stringArray = new String[2];
        stringArray[1] = "two";
        String[] stringArray2 = new String[2];
        stringArray2[1] = "two";
        this.flattenAndUnflatten(stringArray, stringArray2);
        String[] stringArray3 = new String[2];
        stringArray3[0] = "one";
        String[] stringArray4 = new String[2];
        stringArray4[0] = "one";
        this.flattenAndUnflatten(stringArray3, stringArray4);
        Object[] objectArray = new Object[2];
        objectArray[1] = "two";
        String[] stringArray5 = new String[2];
        stringArray5[1] = "two";
        this.flattenAndUnflatten(objectArray, stringArray5);
        this.flattenAndUnflatten(new String[2], new Object[2]);
        this.flattenAndUnflatten(new Object[2], new Object[2]);
        IntegerDataset integerDataset = (IntegerDataset)AbstractDataset.arange(10.0, 3);
        DoubleDataset doubleDataset = (DoubleDataset)AbstractDataset.arange(10.0, 6);
        this.flattenAndUnflatten(new IDataset[]{integerDataset, doubleDataset});
        this.flattenAndUnflatten(new IntegerDataset[]{integerDataset, integerDataset});
        this.flattenAndUnflatten(new ROIBase[]{new RectangularROI(), new SectorROI()});
        this.flattenAndUnflatten(new RectangularROI[]{new RectangularROI(), new RectangularROI()});
    }

    @Test
    public void testLists() {
        ArrayList<RectangularROI> arrayList = new ArrayList<RectangularROI>();
        arrayList.add(new RectangularROI(15.0, 0.2));
        arrayList.add(new RectangularROI(10.1, 11.2, 0.0));
        arrayList.add(new RectangularROI());
        this.flattenAndUnflatten(arrayList, arrayList.toArray(new RectangularROI[0]));
        ArrayList<Number> arrayList2 = new ArrayList<Number>();
        arrayList2.add(new Double(0.0));
        arrayList2.add(new Integer(1));
        this.flattenAndUnflatten(arrayList2, arrayList2.toArray(new Object[0]));
    }

    @Test
    public void testNull() {
        this.flattenAndUnflatten(null, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(null, "null");
        this.flattenAndUnflatten(hashMap, hashMap, Map.class);
        hashMap.put("null", null);
        this.flattenAndUnflatten(hashMap, hashMap, Map.class);
        hashMap.put(null, null);
        this.flattenAndUnflatten(hashMap, hashMap, Map.class);
        String[] stringArray = new String[2];
        stringArray[0] = "null";
        String[] stringArray2 = stringArray;
        this.flattenAndUnflatten(stringArray2);
        this.flattenAndUnflatten(Arrays.asList(stringArray2), stringArray2);
    }

    @Test
    public void testTypedNull() {
        TypedNone typedNone = new TypedNone(Double.class);
        this.flattenAndUnflatten(typedNone, typedNone);
        TypedNone typedNone2 = new TypedNone(RectangularROI.class);
        this.flattenAndUnflatten(typedNone2, typedNone2);
    }

    @Test
    public void testGuiBean() {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)"myfile.txt"));
        guiBean.put(GuiParameters.TITLE, (Serializable)((Object)"My Amazing Plot!"));
        guiBean.put(GuiParameters.PLOTID, UUID.fromString("93dfd804-85ba-4074-afce-d621f7f2aac6"));
        RectangularROI rectangularROI = new RectangularROI(1.1, -2.0, 5.0, 10.0, 0.6, true);
        guiBean.put(GuiParameters.ROIDATA, rectangularROI);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("File1.plot");
        arrayList.add("File2.plot");
        guiBean.put(GuiParameters.FILESELECTEDLIST, arrayList);
        Integer[] integerArray = new Integer[]{12, 14};
        guiBean.put(GuiParameters.IMAGEGRIDSIZE, (Serializable)integerArray);
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.SCATTER2D);
        guiBean.put(GuiParameters.GRIDPREFERENCES, new GridPreferences());
        guiBean.put(GuiParameters.FILEOPERATION, new FileOperationBean());
        this.flattenAndUnflatten(guiBean);
    }

    @Test
    public void testDataBean() throws DataBeanException {
        DataBean dataBean = new DataBean();
        dataBean.addAxis("x-axis", AbstractDataset.arange(100.0, 3));
        dataBean.addAxis("2nd x-axis", AbstractDataset.arange(100.0, 6));
        dataBean.addData(DataSetWithAxisInformation.createAxisDataSet(AbstractDataset.arange(100.0, 3)));
        this.flattenAndUnflatten(dataBean);
    }

    @Test
    public void testAbstractDataset() throws Exception {
        this.flattenAndUnflatten(AbstractDataset.arange(100.0, 3));
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 3);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("", abstractDataset);
        File file = File.createTempFile("scisofttmp-", ".npy");
        new NumPyFileSaver(file.toString()).saveFile(dataHolder);
        AbstractDatasetDescriptor abstractDatasetDescriptor = new AbstractDatasetDescriptor();
        abstractDatasetDescriptor.setFilename(file.toString());
        abstractDatasetDescriptor.setDeleteAfterLoad(false);
        abstractDatasetDescriptor.setIndex(0);
        abstractDatasetDescriptor.setName(null);
        this.flattenAndUnflatten(abstractDatasetDescriptor, abstractDataset);
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    @Test
    public void testROIBase() {
        this.flattenAndUnflatten(new ROIBase());
        ROIBase rOIBase = new ROIBase();
        rOIBase.setPoint(new double[]{-0.3, 2.0});
        this.flattenAndUnflatten(rOIBase);
        rOIBase.setPlot(true);
        this.flattenAndUnflatten(rOIBase);
        rOIBase.setPlot(false);
        this.flattenAndUnflatten(rOIBase);
    }

    @Test
    public void testLinearROI() {
        this.flattenAndUnflatten(new LinearROI(1.1, 0.6));
        double[] dArray = new double[]{-0.3, 2.0};
        double[] dArray2 = new double[]{20.0, -22.5};
        LinearROI linearROI = new LinearROI(dArray, dArray2);
        this.flattenAndUnflatten(linearROI);
        linearROI.setCrossHair(true);
        this.flattenAndUnflatten(linearROI);
    }

    @Test
    public void testRectanglularROI() {
        this.flattenAndUnflatten(new RectangularROI(1.1, -2.0, 5.0, 10.0, 0.6, true));
        this.flattenAndUnflatten(new RectangularROI(-11.2, 2.8, 5.7, 10.2, 0.4, false));
    }

    @Test
    public void testSectorROI() {
        SectorROI sectorROI = new SectorROI(0.2, 15.2, 0.1, 0.2, 0.01, -0.2, 1.0, true, 2);
        this.flattenAndUnflatten(sectorROI);
        sectorROI = new SectorROI(2.3, 1.2, 0.02, 0.04, 0.71, -0.9, 1.0, false, 1);
        sectorROI.setAverageArea(true);
        sectorROI.setCombineSymmetry(true);
        this.flattenAndUnflatten(sectorROI);
    }

    @Test
    public void testLinearROIList() {
        LinearROIList linearROIList = new LinearROIList();
        linearROIList.add(new LinearROI(1.1, 0.6));
        linearROIList.add(new LinearROI(0.9, 0.36));
        this.flattenAndUnflatten(linearROIList);
    }

    @Test
    public void testRectangularROIList() {
        RectangularROIList rectangularROIList = new RectangularROIList();
        rectangularROIList.add(new RectangularROI(1.1, -2.0, 5.0, 10.0, 0.6, true));
        rectangularROIList.add(new RectangularROI(-1.9, -2.0, 5.8, 2.0, 0.9, false));
        this.flattenAndUnflatten(rectangularROIList);
    }

    @Test
    public void testSectorROIList() {
        SectorROIList sectorROIList = new SectorROIList();
        sectorROIList.add(new SectorROI(0.2, 15.2, 0.1, 0.2, 0.01, -0.2, 1.0, true, 2));
        sectorROIList.add(new SectorROI(0.3, -12.0, 0.0, 1.1, 0.651, -0.2, 1.0, true, 6));
        this.flattenAndUnflatten(sectorROIList);
    }

    @Test
    public void testDataSetWithAxisInformation() {
        DataSetWithAxisInformation dataSetWithAxisInformation = DataSetWithAxisInformation.createAxisDataSet(AbstractDataset.arange(100.0, 3));
        this.flattenAndUnflatten(dataSetWithAxisInformation);
    }

    @Test
    public void testAxisMapBean() {
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.FULL);
        String[] stringArray = new String[]{"x-axis", "y-axis"};
        axisMapBean.setAxisID(stringArray);
        this.flattenAndUnflatten(axisMapBean);
    }

    @Test
    public void testException() {
        this.flattenAndUnflatten(new Exception("Exceptional things happened"));
        NullPointerException nullPointerException = new NullPointerException("Exceptional null happened");
        this.flattenAndUnflatten(nullPointerException, nullPointerException, Exception.class);
    }

    @Test
    public void testGuiParameters() {
        this.flattenAndUnflatten(GuiParameters.PLOTMODE);
        GuiParameters[] guiParametersArray = GuiParameters.values();
        int n = guiParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiParameters guiParameters = guiParametersArray[n2];
            this.flattenAndUnflatten(guiParameters);
            ++n2;
        }
    }

    @Test
    public void testGuiPlotMode() {
        this.flattenAndUnflatten(GuiPlotMode.EMPTY);
        GuiPlotMode[] guiPlotModeArray = GuiPlotMode.values();
        int n = guiPlotModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiPlotMode guiPlotMode = guiPlotModeArray[n2];
            this.flattenAndUnflatten(guiPlotMode);
            ++n2;
        }
    }

    @Test
    public void testUUID() {
        this.flattenAndUnflatten(UUID.fromString("93dfd804-85ba-4074-afce-d621f7f2aac6"));
        this.flattenAndUnflatten(UUID.fromString("dd09fd5c-bb75-4c8b-854b-7f3bb2c9c399"));
        this.flattenAndUnflatten(UUID.fromString("00000000-0000-0000-0000-000000000000"));
        this.flattenAndUnflatten(UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff"));
        this.flattenAndUnflatten(UUID.fromString("FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF"));
        int n = 0;
        while (n < 100) {
            this.flattenAndUnflatten(UUID.randomUUID());
            ++n;
        }
    }

    @Test
    public void testPrimitiveArrays() {
        int[] nArray = new int[]{1, 5, -7};
        this.flattenAndUnflatten(nArray);
        this.flattenAndUnflatten(ArrayUtils.toObject((int[])nArray), nArray);
        double[] dArray = new double[]{1.4, 12.6, 0.0};
        this.flattenAndUnflatten(dArray);
        this.flattenAndUnflatten(ArrayUtils.toObject((double[])dArray), dArray);
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[3] = true;
        boolean[] blArray2 = blArray;
        this.flattenAndUnflatten(blArray2);
        this.flattenAndUnflatten(ArrayUtils.toObject((boolean[])blArray2), blArray2);
        double[][] dArrayArray = new double[][]{{1.0, 5.0, -7.0}, {1.4, 12.6, 0.0}};
        this.flattenAndUnflatten(dArrayArray, new double[][]{dArrayArray[0], dArrayArray[1]});
        this.flattenAndUnflatten(new double[][]{dArrayArray[0], dArrayArray[1]});
    }
}

