/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.ExplicitFlatteningTestAbstract;

public class FlatteningTest
extends ExplicitFlatteningTestAbstract {
    @Override
    protected Object doAdditionalWorkOnFlattendForm(Object object) {
        return object;
    }

    @Test
    public void testGuiBeanReallyGaveMeAGuiBean() {
        Assert.assertTrue((boolean)(flattener.unflatten(this.flattenAndCheck(new GuiBean())) instanceof GuiBean));
    }

    @Test
    public void testGuiBean_PLOTIDAsString() {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTID, UUID.fromString("93dfd804-85ba-4074-afce-d621f7f2aac6"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__type__", GuiBean.class.getCanonicalName());
        hashMap.put(GuiParameters.PLOTID.toString(), "93dfd804-85ba-4074-afce-d621f7f2aac6");
        Object object = flattener.unflatten(hashMap);
        this.assertFlattenEquals(guiBean, object);
    }

    @Test
    public void testGuiBean_PLOTMODEAsString() {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.MULTI2D);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__type__", GuiBean.class.getCanonicalName());
        hashMap.put(GuiParameters.PLOTMODE.toString(), GuiPlotMode.MULTI2D.toString());
        Object object = flattener.unflatten(hashMap);
        this.assertFlattenEquals(guiBean, object);
    }

    @Test
    public void testGuiBean_keysAsString() {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.MULTI2D);
        guiBean.put(GuiParameters.TITLE, (Serializable)((Object)"My amazing plot"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__type__", GuiBean.class.getCanonicalName());
        hashMap.put(GuiParameters.PLOTMODE.toString(), GuiPlotMode.MULTI2D.toString());
        hashMap.put("Title", "My amazing plot");
        Object object = flattener.unflatten(hashMap);
        this.assertFlattenEquals(guiBean, object);
    }

    @Test
    public void testCheckFlattanableFalse() {
        Assert.assertFalse((boolean)flattener.canFlatten(new Object()));
    }

    @Test
    public void testCheckUnFlattanableFalse() {
        Assert.assertFalse((boolean)flattener.canUnFlatten(new Object()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFlattanableUnsupported() {
        flattener.flatten(new Object());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnFlattanableUnsupported() {
        flattener.unflatten(new Object());
    }
}

