/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;

public class BasicFlatteningTest {
    @Test
    public void basicTest() {
        RootFlattener rootFlattener = new RootFlattener();
        Assert.assertEquals((Object)18, (Object)rootFlattener.unflatten(rootFlattener.flatten(18)));
        Assert.assertEquals((Object)"hello", (Object)rootFlattener.unflatten(rootFlattener.flatten("hello")));
        int[] nArray = new int[]{1, 2, 3};
        Assert.assertArrayEquals((int[])nArray, (int[])((int[])rootFlattener.unflatten(rootFlattener.flatten(nArray))));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("one", 1);
        hashMap.put("two", 2);
        hashMap.put("three", 3);
        Assert.assertEquals(hashMap, (Object)rootFlattener.unflatten(rootFlattener.flatten(hashMap)));
        RectangularROI rectangularROI = new RectangularROI(100.0, 2.3);
        RectangularROI rectangularROI2 = (RectangularROI)rootFlattener.unflatten(rootFlattener.flatten(rectangularROI));
        Assert.assertEquals((double)rectangularROI.getAngle(), (double)rectangularROI2.getAngle(), (double)0.0);
        Assert.assertArrayEquals((double[])rectangularROI.getPoint(), (double[])rectangularROI2.getPoint(), (double)0.0);
        Assert.assertArrayEquals((double[])rectangularROI.getLengths(), (double[])rectangularROI2.getLengths(), (double)0.0);
    }
}

