/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;

public class AddHelperSpecializedMapFlatteningTest {
    @Test
    public void testAddNewHelper() {
        RootFlattener rootFlattener = new RootFlattener();
        MySpecialMap mySpecialMap = new MySpecialMap();
        try {
            mySpecialMap.put("hello", "goodbye");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        mySpecialMap.putIdentity("foo");
        mySpecialMap.putIdentity("bar");
        Assert.assertTrue((boolean)rootFlattener.canFlatten(mySpecialMap));
        Map map = (Map)rootFlattener.unflatten(rootFlattener.flatten(mySpecialMap));
        map.put("hello", "goodbye");
        rootFlattener.addHelper(new AddHelperIFlattener());
        Map map2 = (Map)rootFlattener.unflatten(rootFlattener.flatten(mySpecialMap));
        Assert.assertTrue((boolean)(map2 instanceof MySpecialMap));
        try {
            map2.put("hello", "goodbye");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    private static class AddHelperIFlattener
    implements IFlattener<MySpecialMap> {
        private static final String CONTENTS = "contents";

        private AddHelperIFlattener() {
        }

        @Override
        public Object flatten(Object object, IRootFlattener iRootFlattener) {
            MySpecialMap mySpecialMap = (MySpecialMap)object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("__type__", MySpecialMap.class.getCanonicalName());
            hashMap.put(CONTENTS, mySpecialMap.keySet().toArray());
            return hashMap;
        }

        @Override
        public MySpecialMap unflatten(Object object, IRootFlattener iRootFlattener) {
            Object[] objectArray;
            Map map = (Map)object;
            MySpecialMap mySpecialMap = new MySpecialMap();
            Object[] objectArray2 = objectArray = (Object[])map.get(CONTENTS);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                mySpecialMap.putIdentity((String)object2);
                ++n2;
            }
            return mySpecialMap;
        }

        @Override
        public boolean canFlatten(Object object) {
            return object instanceof MySpecialMap;
        }

        @Override
        public boolean canUnFlatten(Object object) {
            if (object instanceof Map) {
                Map map = (Map)object;
                if (MySpecialMap.class.getCanonicalName().equals(map.get("__type__"))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class MySpecialMap
    extends AbstractMap<String, String> {
        private Map<String, String> map = new HashMap<String, String>();

        private MySpecialMap() {
        }

        public void putIdentity(String string) {
            this.map.put(string, string);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.map.entrySet();
        }
    }
}

