/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IFlattens;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;

public class AddHelperSimpleWithInterfaceFlatteningTest {
    @Test
    public void testAddNewHelper() {
        RootFlattener rootFlattener = new RootFlattener();
        Assert.assertTrue((boolean)rootFlattener.canFlatten(new AddHelperMockClass(23)));
        Object object = rootFlattener.flatten(new AddHelperMockClass(23));
        Assert.assertFalse((boolean)rootFlattener.canUnFlatten(object));
        rootFlattener.addHelper(new AddHelperIFlattener());
        Assert.assertTrue((boolean)rootFlattener.canUnFlatten(object));
        Object object2 = rootFlattener.unflatten(object);
        Assert.assertTrue((boolean)(object2 instanceof AddHelperMockClass));
        Assert.assertEquals((long)23L, (long)((AddHelperMockClass)object2).getValue());
    }

    private static class AddHelperIFlattener
    implements IFlattener<AddHelperMockClass> {
        private static final String VALUE = "value";

        private AddHelperIFlattener() {
        }

        @Override
        public Object flatten(Object object, IRootFlattener iRootFlattener) {
            throw new AssertionError();
        }

        @Override
        public boolean canFlatten(Object object) {
            return false;
        }

        @Override
        public AddHelperMockClass unflatten(Object object, IRootFlattener iRootFlattener) {
            Map map = (Map)object;
            return new AddHelperMockClass((Integer)map.get(VALUE));
        }

        @Override
        public boolean canUnFlatten(Object object) {
            if (object instanceof Map) {
                Map map = (Map)object;
                if (AddHelperMockClass.class.getCanonicalName().equals(map.get("__type__"))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class AddHelperMockClass
    implements IFlattens {
        private int value;

        public AddHelperMockClass(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public Object flatten(IRootFlattener iRootFlattener) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("__type__", AddHelperMockClass.class.getCanonicalName());
            hashMap.put("value", this.getValue());
            return hashMap;
        }
    }
}

