/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc.flattening;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.RootFlattener;

public class AddHelperSimpleFlatteningTest {
    @Test
    public void testAddNewHelper() {
        RootFlattener rootFlattener = new RootFlattener();
        Assert.assertFalse((boolean)rootFlattener.canFlatten(new AddHelperMockClass(23)));
        rootFlattener.addHelper(new AddHelperIFlattener());
        Assert.assertTrue((boolean)rootFlattener.canFlatten(new AddHelperMockClass(56)));
        Object object = rootFlattener.unflatten(rootFlattener.flatten(new AddHelperMockClass(78)));
        Assert.assertTrue((boolean)(object instanceof AddHelperMockClass));
        Assert.assertEquals((long)78L, (long)((AddHelperMockClass)object).getValue());
    }

    private static class AddHelperIFlattener
    implements IFlattener<AddHelperMockClass> {
        private static final String VALUE = "value";

        private AddHelperIFlattener() {
        }

        @Override
        public Object flatten(Object object, IRootFlattener iRootFlattener) {
            AddHelperMockClass addHelperMockClass = (AddHelperMockClass)object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("__type__", AddHelperMockClass.class.getCanonicalName());
            hashMap.put(VALUE, addHelperMockClass.getValue());
            return hashMap;
        }

        @Override
        public AddHelperMockClass unflatten(Object object, IRootFlattener iRootFlattener) {
            Map map = (Map)object;
            return new AddHelperMockClass((Integer)map.get(VALUE));
        }

        @Override
        public boolean canFlatten(Object object) {
            return object instanceof AddHelperMockClass;
        }

        @Override
        public boolean canUnFlatten(Object object) {
            if (object instanceof Map) {
                Map map = (Map)object;
                if (AddHelperMockClass.class.getCanonicalName().equals(map.get("__type__"))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class AddHelperMockClass {
        private int value;

        public AddHelperMockClass(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }
}

